<?php
/**
 * @copyright	Copyright (C) 2011 Cédric KEIFLIN alias ced1870
 * https://www.joomlack.fr
 * Accordeon Menu CK
 * @license		GNU/GPL
 * Adapted from the original mod_menu on Joomla.site - Copyright (C) 2005 - 2011 Open Source Matters, Inc. All rights reserved.
 * */

// no direct access
defined('_JEXEC') or die('Restricted access');

use Accordeonmenuck\Helperfront;
use Accordeonmenuck\Helper;

require_once JPATH_ADMINISTRATOR . '/components/com_accordeonmenuck/helpers/defines.php';
require_once ACCORDEONMENUCK_PATH . '/helpers/ckfof.php';
require_once ACCORDEONMENUCK_PATH . '/helpers/helper.php';
require_once ACCORDEONMENUCK_FRONT_PATH . '/helpers/helperfront.php';
// load old helper because we still need it
require_once dirname(__FILE__) . '/helper.php';

// set the default html id for the menu
if ( $params->get('tag_id', '') === '' || is_numeric($params->get('tag_id', ''))) {
	$params->set('tag_id', 'accordeonck' . $module->id);
	$params->set('menuid', 'accordeonck' . $module->id);
}
$menuID = $params->get('tag_id', 'accordeonck' . $module->id);
$loadfontawesome = false;

// check the compilation process
$doCompile = false;
// if one of the compile option is active (compile or yes)
if ($params->get('loadcompiledcss', '0') != '0') {
	if ( $params->get('loadcompiledcss', '0') == '2'
			|| ! file_exists(dirname(__FILE__) . '/themes/custom/css/' . $menuID . '.css') ) {
		$doCompile = true;
	}
}
// set the doCompile params to use in the helper for menu items css
$params->set('doCompile', $doCompile);

// load the items
$source = $params->get('source', 'menu');
if ($source != 'menu') {
	$sourceFile = ACCORDEONMENUCK_PLUGINS_PATH . '/' . strtolower($source) . '/helper/helper_' . strtolower($source) . '.php';
	if (! file_exists($sourceFile)) {
		echo '<p syle="color:red;">Error : File plugins/accordeonmenuck/' . strtolower($source) . '/helpers/helper_' . strtolower($source) . '.php not found !</p>';
		return;
	}
	require_once $sourceFile;
} else {
	require_once ACCORDEONMENUCK_FRONT_PATH . '/helpers/source/' . $source . '.php';
}

$loaderClass = 'AccordeonmenuckHelpersource' . ucfirst($source);
$items = $loaderClass::getItems($params);

if (empty($items)) return;

// B/C
$nLevel1 = 0;
foreach ($items as $item) {
	if ($item->level == 1) $nLevel1++;
	// B/C to avoid php errors, because of migration to J4
	if (! isset($item->fparams)) $item->fparams = $item->params;
}

$document = JFactory::getDocument();
$app = JFactory::getApplication();
$menu = $app->getMenu();
$active = $menu->getActive();
$active_id = isset($active) ? $active->id : $menu->getDefault()->id;
$path = isset($active) ? $active->tree : array();
$showAll = 1;
$class_sfx = htmlspecialchars((string)$params->get('class_sfx', ''));

// retrieve parameters from the module
$startlevel = $params->get('startLevel', '0');
$endlevel = $params->get('endLevel', '10');
$mooduration = $params->get('mooduration', 500);
$mootransition = $params->get('mootransition', 'linear');
$imageplus = $params->get('imageplus', 'modules/mod_accordeonmenuck/assets/plus.png');
$imageminus = $params->get('imageminus', 'modules/mod_accordeonmenuck/assets/minus.png');
$imageposition = $params->get('imageposition', 'right');
$eventtype = $params->get('eventtype', 'click');
$fadetransition = $params->get('fadetransition', 'false');
$theme = $params->get('theme', 'default');

// get the language direction
$langdirection = $document->getDirection();

// load the css and js in the page	
//JHTML::_("behavior.framework", true);
JHTML::_("jquery.framework", true);
// JHTML::_("jquery.ui");

$debug = true;
if ($debug == true) {
	$document->addScript(ACCORDEONMENUCK_MEDIA_URI . '/assets/accordeonmenuck.js');
} else {
	$document->addScript(ACCORDEONMENUCK_MEDIA_URI . '/assets/accordeonmenuck.min.js');
}
$document->addScript(ACCORDEONMENUCK_MEDIA_URI . '/assets/jquery.easing.1.3.js');

// if a theme has been selected, load the css from it
if ( $theme != '-1' ) {
	if ($params->get('loadcompiledcss', '0') == '0') {
		if ( file_exists(dirname(__FILE__) . '/themes/' . $theme . '/css.php') ) {
			if ($langdirection == 'rtl' && file_exists(dirname(__FILE__) . '/themes/' . $theme . '/css_rtl.php')) {
				$document->addStyleSheet(JURI::base(true) . '/modules/mod_accordeonmenuck/themes/' . $theme . '/css_rtl.php?cssid=' . $menuID);
			} else {
				$document->addStyleSheet(JURI::base(true) . '/modules/mod_accordeonmenuck/themes/' . $theme . '/css.php?cssid=' . $menuID);
			}
		// B/C for old themes before V3
		} else if ( file_exists(dirname(__FILE__) . '/themes/' . $theme . '/mod_accordeonck_css.php') ) {
			$document->addStyleSheet(JURI::base(true) . '/modules/mod_mod_accordeonck_css/themes/' . $theme . '/mod_accordeonck_css.php?cssid=' . $menuID);
		}
	}
}

// load all CSS in a single file if compiled, else load in the page
// styles from the theme
$themeCss = '';
if ((int)$params->get('loadcompiledcss', '0') > '0') {
	if ( $doCompile ) {
		$themeCss .= Helperfront::getCompiledCss($params, $langdirection);
	}
	// specific for menu items settings 
	if ( $doCompile && $source == 'menu') {
		$themeCss .= AccordeonmenuckHelpersourceMenu::getCompiledCss($params);
	}
	$langsuffix = $langdirection == 'rtl' ? '_rtl' : '';
	$document->addStyleSheet(JURI::base(true) . '/modules/mod_accordeonmenuck/themes/custom/css/' . $menuID . $langsuffix . '.css');
}


$js = "jQuery(document).ready(function(jQuery){"
		. "new Accordeonmenuck('#" . $menuID . "', {"
		. "fadetransition : " . $fadetransition . ","
		. "eventtype : '" . $eventtype . "',"
		. "transition : '" . $mootransition . "',"
		. "menuID : '" . $menuID . "',"
   //		. "imageplus : '" . JURI::base(true) . '/' . $imageplus . "',"
   //		. "imageminus : '" . JURI::base(true) . '/' . $imageminus . "',"
		. "defaultopenedid : '" . $params->get('defaultopenedid') . "',"
		. "activeeffect : '" . (bool) $params->get('activeeffect') . "',"
		. "showcounter : '" . (bool) $params->get('showcounter', false) . "',"
		. "showactive : '" . (bool) $params->get('showactive', true) . "',"
		. "closeothers : '" . (int) $params->get('closeothers', true) . "',"
		. "duree : " . $mooduration
		. "});"
	 . "}); ";

$document->addScriptDeclaration($js);

// $list = modAccordeonmenuckHelper::getMenu($params);


// styles from the styling interface
$styleCss = '';
$styleId = $params->get('styles', 0, 'int');
if ($styleId) {
	require_once ACCORDEONMENUCK_PATH . '/helpers/style.php';
	$styleCss = Accordeonmenuck\Style::getCss($styleId);
	$styleCss = str_replace('|ID|', $menuID, $styleCss);
}

if (! empty($items)) {
	require JModuleHelper::getLayoutPath('mod_accordeonmenuck', $params->get('layout', 'default'));
}

// load font awesome if needed
global $ckfontawesomeisloaded;
global $ckfontawesomev5isloaded;
$fontawesomeversion = $params->get('fontawesomeversion', '5');
if ($params->get('loadfontawesomescript', '1') == '1') {
	if ($loadfontawesome && $fontawesomeversion == '4' && !$ckfontawesomeisloaded) {
		$document->addStyleSheet(ACCORDEONMENUCK_MEDIA_URI . '/assets/font-awesome.min.css');
		$ckfontawesomeisloaded = true;
	} else if ($loadfontawesome && $fontawesomeversion == '5' && !$ckfontawesomev5isloaded) {
		$document->addStyleSheet(ACCORDEONMENUCK_MEDIA_URI . '/assets/fontawesome.all.min.css');
		$ckfontawesomev5isloaded = true;
	}
}

// manage googlefonts
$loadgooglefonts = $params->get('loadgooglefonts', 'auto');
if ($loadgooglefonts == 'auto') {
	preg_match( '/font-family: \'(.*?)\'/', $styleCss, $matches);
	foreach($matches as $font) {
		$font = str_replace(' ', '+', ucwords (trim($font)));
		$font = trim(trim($font, "'"));
		if (isset($font[1])) $document->addStylesheet('https://fonts.googleapis.com/css?family=' . $font);
	}
} else if ($loadgooglefonts == 'custom') {
	$customgooglefonts = $params->get('customgooglefonts', '');
	$customgooglefonts = explode("\n", $customgooglefonts);
	foreach ($customgooglefonts as $font) {
		$document->addStylesheet(trim($font));
	}
}

// style for icons
$iconCss = '';
if ($loadfontawesome) {
	$iconCss = '
#' . $menuID . ' .accordeonmenuiconck {
	align-self: center;
	' . ($params->get('faiconpositionlevel1', 'left') == 'left' ? 'margin-right: ' : 'margin-bottom: ') . Helper::testUnit($params->get('faiconmargin', '5px')) . ';
}
';
}

//additional styles
$moreCss = '#' . $menuID . ' ul[class^="content"] {
	display: none;
}';

// combine all styles
$allCss = $themeCss . $styleCss . $iconCss . $moreCss;
if ( $doCompile ) {
	$cssfile = dirname(__FILE__) . '/themes/custom/css/' . $menuID . '.css';
	if (! file_exists(dirname(__FILE__) . '/themes/custom/css/')) {
		JFolder::create(dirname(__FILE__) . '/themes/custom/css/');
	}

	// store the css in the file, if error then load the css directly in the page
	if (! file_put_contents($cssfile, $allCss)) {
		$document->addStyleDeclaration($allCss); // fallback if compile fails
	}
} else {
	$document->addStyleDeclaration($allCss);
}