<?php
// no direct access
defined('_JEXEC') or die;

use Accordeonmenuck\Helper;
use Accordeonmenuck\Helperfront;
use Accordeonmenuck\Style;

require_once ACCORDEONMENUCK_PATH . '/helpers/helper.php';
require_once ACCORDEONMENUCK_PATH . '/helpers/style.php';

class AccordeonmenuckHelpersourceMenu {

	private static $_itemcss;

	private static $_modulecss;

	/**
	 * Get a list of the menu items.
	 *
	 * @param	JRegistry	$params	The module options.
	 *
	 * @return	array
	 */
	static function getItems(&$params, $all = false, $level = 1, $parent_id = 0) {
		$app = JFactory::getApplication();
		$menu = $app->getMenu();

		// If no active menu, use default
		$active = ($menu->getActive()) ? $menu->getActive() : $menu->getDefault();
		$active_id = isset($active) ? $active->id : $menu->getDefault()->id;
		$base = self::getBase($params);

//		$user = JFactory::getUser();
//		$levels = $user->getAuthorisedViewLevels();
//		asort($levels);
//		$key = 'menu_items' . $params . implode(',', $levels) . '.' . $active->id;
//		$cache = JFactory::getCache('mod_accordeonmenuck', '');
//		if (!($items = $cache->get($key)) || (int) $params->get('cache') == '0') {
			// Initialise variables.
			$list = array();
			$modules = array();
			$db = JFactory::getDbo();
			$document = JFactory::getDocument();

			// load the libraries
			jimport('joomla.application.module.helper');

			$path = is_array($base->tree) ? $base->tree : array(); // pb si on utilise cela, lorsque base item est sur autre que courant, Ã§a ne marche plus. Le path renvoit uniquement le lien base item
			$pathActive = isset($active) ? $active->tree : $path;
			$start = (int) $params->get('startLevel');
			$end = (int) $params->get('endLevel');
			$showAll = 1;
			$items = $menu->getItems('menutype', $params->get('menutype'));

			// if no items in the menu then exit
			if (!$items)
				return false;

			$hidden_parents = array();
			$lastitem = 0;
			// list all modules
			$modulesList = Helperfront::CreateModulesList();

			// check for imbrication with third party items
			$nbadditems = 0;
			foreach ($items as $i => $item) {
				if ($item->type == 'component' && $item->component == 'com_accordeonmenuckhikashop'|| ($item->component == 'com_accordeonmenuck' && $item->query['view'] == 'sources')) {
					$itemparams = new JRegistry();
					if (isset($item->query) && is_array($item->query)) {
						$itemparams->loadArray($item->query);
					}
					if ($item->component == 'com_accordeonmenuckhikashop') {
						require_once JPATH_ROOT . '/plugins/system/accordeonmenuck_hikashop/helper/helper_accordeonmenuck_hikashop.php';
						$className = 'modAccordeonmenuckhikashopHelper';
					} else {
						$source = $itemparams->get('accordeonmenuck_plugin_type');
						$sourceFile = ACCORDEONMENUCK_PLUGINS_PATH . '/' . strtolower($source) . '/helper/helper_' . strtolower($source) . '.php';
						if (! file_exists($sourceFile)) {
							echo '<p syle="color:red;">Error : File plugins/accordeonmenuck/' . strtolower($source) . '/helpers/helper_' . strtolower($source) . '.php not found !</p>';
							return;
						}
						require_once $sourceFile;
						$className = 'AccordeonmenuckHelpersource' . ucfirst($source);
					}
					$additems = $className::getItems($itemparams, false, $item->level, $item->parent_id);


					if (method_exists($className, 'hasActive') && $className::hasActive()) {

						$search = 0;
						foreach ($items as $temp_parent) {
							if ($temp_parent->id === $item->parent_id) {
								break;
							}
						$search++;
						}
						$temp_parent->classe .= ' active';
						$temp_parent->active = true;
						$temp_parent->isactive = true;
					}

					if (is_int($i)) {
						array_splice($items, $i + $nbadditems, 1, $additems);
					} else {
						$pos   = array_search($i, array_keys($items));
						$items = array_merge(
							array_slice($items, 1, $pos),
							$additems,
							array_slice($items, $pos)
						);
					}
					$nbadditems += count($additems) - 1;
				}
				$lastitem = $i;
			}

			$lastitem = 0;

			foreach ($items as $i => $item) {
				// migration method to use with Joomla 4 where $item->params is protected
					if (method_exists($item, 'getParams')) {
						$item->fparams = $item->getParams();
						try {
							$prop = new ReflectionProperty(get_class($item), 'params');
							if (! $prop->isProtected()) {
								$item->params = $item->fparams;
							}
						} catch (Exception $e) {
							// echo 'Exception reÃ§ue : ',  $e->getMessage(), "\n";
						}
					// B/C definition, and for other items not coming from the joomla menus
					} else {
						$item->fparams = $item->params;
					}																						
				$isdependant = $params->get('dependantitems', false) ? ($start > 1 && !in_array($item->tree[$start - 2], $path)) : false;
				$item->isthirdparty = (isset($item->isthirdparty) && $item->isthirdparty) ? true : false;
				$item->parent = false;

				if (isset($items[$lastitem]) && isset($item->parent_id) && $items[$lastitem]->id == $item->parent_id && $item->fparams->get('menu_show', 1) == 1)
				{
					$items[$lastitem]->parent = true;
				}

				if (! $item->isthirdparty && (($start && $start > $item->level) || ($end && $item->level > $end) || $isdependant)
				) {
					unset($items[$i]);
					continue;
				}

// if (! isset($item->parent_id)) $item->parent_id = 0;

				// Exclude item with menu item option set to exclude from menu modules
				if (! $item->isthirdparty && (($item->fparams->get('menu_show', 1) == 0) || in_array($item->parent_id, $hidden_parents))
				)
				{
					$hidden_parents[] = $item->id;
					unset($items[$i]);
					continue;
				}

				if (($start && $start > $item->level) 
					|| ($end && $item->level > $end) 
					|| (!$showAll && $item->level > 1 
						&& (!in_array($item->parent_id, $path) && !in_array($item->parent_id, $pathActive))
					)
					|| ($start > 1 && !in_array($item->tree[$start - 2], $path)
						&& $start > 1 && !in_array($item->tree[$start - 2], $pathActive))
				) {
					unset($items[$i]);
					continue;
				}

				// Exclude item with menu item option set to exclude from menu modules
				if (! $item->isthirdparty && (($item->fparams->get('menu_show', 1) == 0) || in_array($item->parent_id, $hidden_parents))
				)
				{
					$hidden_parents[] = $item->id;
					unset($items[$i]);
					continue;
				}

				$item->deeper = false;
				$item->shallower = false;
				$item->level_diff = 0;
				$item->isactive = false;

				if (isset($items[$lastitem])) {
					$items[$lastitem]->deeper = ($item->level > $items[$lastitem]->level);
					$items[$lastitem]->shallower = ($item->level < $items[$lastitem]->level);
					$items[$lastitem]->level_diff = ($items[$lastitem]->level - $item->level);
				}

				// Test if this is the last item
				$item->is_end = !isset($items[$i + 1]);

				// if (! $item->isthirdparty) $item->parent = (boolean) $menu->getItems('parent_id', (int) $item->id, true);
				$item->active = false;
				$item->current = false;
				$item->flink = $item->link;
				if (! isset($item->classe)) $item->classe = '';

				switch ($item->type) {
					case 'separator':
							break;
					case 'heading':
						$item->classe .= ' headingck';
						// No further action needed.
						break;

					case 'url':
						if ((strpos($item->link, 'index.php?') === 0) && (strpos($item->link, 'Itemid=') === false)) {
							// If this is an internal Joomla link, ensure the Itemid is set.
							$item->flink = $item->link . '&Itemid=' . $item->id;
						}
						$item->flink = JFilterOutput::ampReplace(htmlspecialchars($item->flink));
						break;

					case 'thirdparty':
						break;

					case 'alias':
						// If this is an alias use the item id stored in the parameters to make the link.
						$item->flink = 'index.php?Itemid=' . $item->fparams->get('aliasoptions');
						break;

					default:
							$item->flink = 'index.php?Itemid=' . $item->id;
						break;
				}

				if (strcasecmp(substr($item->flink, 0, 4), 'http') && (strpos($item->flink, 'index.php?') !== false)) {
					$item->flink = JRoute::_($item->flink, true, $item->fparams->get('secure'));
				} else {
					$item->flink = JRoute::_($item->flink);
				}

				$item->anchor_css = htmlspecialchars($item->fparams->get('menu-anchor_css', ''), ENT_COMPAT, 'UTF-8', false);
				$item->anchor_title = htmlspecialchars($item->fparams->get('menu-anchor_title', ''), ENT_COMPAT, 'UTF-8', false);
				$item->menu_image = $item->fparams->get('menu_image', '') ? htmlspecialchars($item->fparams->get('menu_image', ''), ENT_COMPAT, 'UTF-8', false) : (isset($item->menu_image) && $item->menu_image ? $item->menu_image : '');



				//  ---------------- begin the work on items --------------------

				$item->ftitle = htmlspecialchars(($item->title == null ? $item->ftitle : $item->title), ENT_COMPAT, 'UTF-8', false);
				$item->ftitle = JFilterOutput::ampReplace($item->ftitle);
				$parentItem = new stdClass();
				
				if (isset($item->parent_id) && $item->parent_id) $parentItem = self::getParentItem($item->parent_id, $items);

				// ---- add some classes ----
				// add itemid class
				$item->classe .= ' item' . $item->id;
				// add current class
				if (isset($active) && $active->id == $item->id) {
					$item->classe .= ' current';
					$item->current = true;
				}
				// add active class
				// if (is_array($path) &&
						// ( ($item->type == 'alias' && in_array($item->fparams->get('aliasoptions'), $path)) || in_array($item->id, $path))) {
					// $item->classe .= ' active';
					// $item->active = true;
				// }
				// add the parent class
				if ($item->deeper) {
					$item->classe .= ' deeper';
				}


				// new method for the active class
				if (	is_array($path) 
					&&	$item->type == 'alias' 
					&&	in_array($item->fparams->get('aliasoptions'),$path)
					||	in_array($item->id, $path)
					||	in_array($item->id, $pathActive)
							) {
							$item->classe .= ' active';
							$item->active = true;
							$item->isactive = true;
				}


				// add last and first class
				$item->classe .= $item->is_end ? ' last' : '';
				$item->classe .= !isset($items[$i - 1]) ? ' first' : '';

				if (isset($items[$lastitem])) {
					if ($items[$lastitem]->parent && ($end == 0 || (int)$items[$lastitem]->level < (int)$end) && ! $items[$lastitem]->isthirdparty) {
						if ($params->get('layout', 'default') != '_:flatlist')
							$items[$lastitem]->classe .= ' parent';
					}
				
					$items[$lastitem]->classe .= $items[$lastitem]->shallower ? ' last' : '';
					$item->classe .= $items[$lastitem]->deeper ? ' first' : '';
					if (isset($items[$i + 1]) AND $item->level - $items[$i + 1]->level > 1 AND $parentItem) {
						$parentItem->classe = isset($parentItem->classe) ? $parentItem->classe . ' last' : 'last';
					}
				}

				// manage the class to show the item on desktop and mobile
				if ($item->fparams->get('accordeonckparams_disablemobile') == '1') {
					$item->classe .= ' nomobileck';
				}

				// compatibility with Mobile Menu CK
				if ($item->fparams->get('mobilemenuck_enablemobile', '1') == '0') {
					$item->classe .= ' mobilemenuck-hide';
				}
				
				if ($item->fparams->get('accordeonckparams_disabledesktop') == '1' || $item->fparams->get('mobilemenuck_enabledesktop', '1') == '0') {
					$item->classe .= ' nodesktopck';
				}


				// ---- manage params ----
				// -- manage column --
				$item->colwidth = $item->fparams->get('accordeonckparams_colwidth', '180');
				$item->createnewrow = $item->fparams->get('accordeonckparams_createnewrow', 0) || stristr($item->ftitle, '[newrow]');
				// check if there is a width for the subcontainer
				preg_match('/\[subwidth=([0-9]+)\]/', $item->ftitle, $subwidth);
				$subwidth = isset($subwidth[1]) ? $subwidth[1] : '';
				if ($subwidth)
					$item->ftitle = preg_replace('/\[subwidth=[0-9]+\]/', '', $item->ftitle);
				$item->submenucontainerwidth = $item->fparams->get('accordeonckparams_submenucontainerwidth', '') ? $item->fparams->get('accordeonckparams_submenucontainerwidth', '') : $subwidth;
				if ($item->fparams->get('accordeonckparams_createcolumn', 0)) {
					$item->colonne = true;
					// add the value to give the total parent container width
					if (isset($parentItem->submenuswidth)) {
						if (! stristr($item->colwidth, '%') 
							&& $item->colwidth != 'auto'
							&& ! stristr($parentItem->submenuswidth, '%')
							&& $parentItem->submenuswidth != 'auto'
							) 
							$parentItem->submenuswidth = (float)($parentItem->submenuswidth) + (float)($item->colwidth);
					} else if (isset($parentItem) && $parentItem) {
						if (! stristr($item->colwidth, '%') 
							&& $item->colwidth != 'auto' 
							) 
							$parentItem->submenuswidth = (float)($item->colwidth);
					}
					// if specified by user with the plugin, then give the width to the parent container
					if (isset($items[$lastitem]) && $items[$lastitem]->deeper) {
						$items[$lastitem]->nextcolumnwidth = $item->colwidth;
					}
					$item->columnwidth = $item->colwidth;
				} elseif (preg_match('/\[col=([0-9]+)\]/', $item->ftitle, $resultat)) {
					$item->ftitle = str_replace('[newrow]', '', $item->ftitle);
					$item->ftitle = preg_replace('/\[col=[0-9]+\]/', '', $item->ftitle);
					$item->colonne = true;
					if (isset($parentItem->submenuswidth)) {
						if (! stristr($item->colwidth, '%') ) $parentItem->submenuswidth = (float)($parentItem->submenuswidth) + (float)($resultat[1]);
					} else {
						if (! stristr($item->colwidth, '%') ) $parentItem->submenuswidth = (float)($resultat[1]);
					}
					if (isset($items[$lastitem]) && $items[$lastitem]->deeper) {
						$items[$lastitem]->nextcolumnwidth = $resultat[1];
					}
					$item->columnwidth = $resultat[1];
				}
				if (isset($parentItem->submenucontainerwidth) AND $parentItem->submenucontainerwidth) {
					$parentItem->submenuswidth = $parentItem->submenucontainerwidth;
				}

				// -- manage module --
				$moduleid = $item->fparams->get('accordeonckparams_module', '');
				$style = $item->fparams->get('accordeonckparams_forcemoduletitle', 0) ? 'xhtml' : '';
				if ($item->fparams->get('accordeonckparams_insertmodule', 0)) {
					if (!isset($modules[$moduleid])) {
						$modules[$moduleid] = Helperfront::GenModuleById($moduleid, $params, $modulesList, $style, $item->level);
					}
					// for menu imbricated, use another css class
					$special_subclass = ($modulesList[$moduleid]->module == 'mod_accordeonmenuck') ? '2' : '';
					$item->content = '<div class="accordeonmenuck_mod' . $special_subclass . '">' . $modules[$moduleid] . '<div class="clr"></div></div>';
				} elseif (preg_match('/\[modid=([0-9]+)\]/', $item->ftitle, $resultat)) {
					// for menu imbricated, use another css class
					$special_subclass = ($modulesList[$resultat[1]]->module == 'mod_accordeonmenuck') ? '2' : '';
					$item->ftitle = preg_replace('/\[modid=[0-9]+\]/', '', $item->ftitle);
					$item->content = '<div class="accordeonmenuck_mod' . $special_subclass . '">' . Helperfront::GenModuleById($resultat[1], $params, $modulesList, $style, $item->level) . '<div class="clr"></div></div>';
				}

				// -- manage rel attribute --
				$item->rel = '';
				if ($rel = $item->fparams->get('accordeonckparams_relattr', $item->fparams->get('menu-anchor_rel', ''))) {
					$item->rel = ' rel="' . $rel . '"';
				} elseif (preg_match('/\[rel=([a-z]+)\]/i', $item->ftitle, $resultat)) {
					$item->ftitle = preg_replace('/\[rel=[a-z]+\]/i', '', $item->ftitle);
					$item->rel = ' rel="' . $resultat[1] . '"';
				}

				// -- manage link description --
				$item->description = $item->fparams->get('accordeonckparams_desc', '');
				if ($item->description) {
					$item->desc = $item->description;
				} else {
					$resultat = explode("||", $item->ftitle);
					if (isset($resultat[1])) {
						$item->desc = $resultat[1];
					} else {
						$item->desc = '';
					}
					$item->ftitle = $resultat[0];
				}

				// add the anchor tag and url suffix
				$item->flink .= $item->fparams->get('accordeonckparams_urlsuffix', '') ? $item->fparams->get('accordeonckparams_urlsuffix', '') : '';
				$item->flink .= $item->fparams->get('accordeonckparams_anchor', '') ? '#' . $item->fparams->get('accordeonckparams_anchor', '') : '';

				// add styles to the page for customization
				$menuID = $params->get('menuid', 'accordeonmenuck');

				// get plugin parameters that are used directly in the layout
				$item->leftmargin = $item->fparams->get('accordeonckparams_leftmargin', '');
				$item->topmargin = $item->fparams->get('accordeonckparams_topmargin', '');
				$item->liclass = $item->fparams->get('accordeonckparams_liclass', '');
				$item->colbgcolor = $item->fparams->get('accordeonckparams_colbgcolor', '');
				$item->tagcoltitle = $item->fparams->get('accordeonckparams_tagcoltitle', 'none');
				$item->submenucontainerheight = $item->fparams->get('accordeonckparams_submenucontainerheight', '');
				$item->access_key = htmlspecialchars($item->fparams->get('accordeonckparams_accesskey', ''), ENT_COMPAT, 'UTF-8', false);

				// get mobile plugin parameters that are used directly in the layout
				$item->mobile_data = '';
//				$mobileicon = $item->fparams->get('maximenumobile_icon', $item->fparams->get('mobilemenuck_icon', ''));
//				$item->mobile_data .= $mobileicon ? ' data-mobileicon="' . $mobileicon . '"' : '';
//				$mobiletext = $item->fparams->get('maximenumobile_textreplacement', $item->fparams->get('mobilemenuck_textreplacement', ''));
//				$item->mobile_data .= $mobiletext ? ' data-mobiletext="' . $mobiletext . '"' : '';

				// set the item styles if the plugin is enabled
				if (JPluginHelper::isEnabled('system', 'accordeonmenuck')) {
					if ($params->get('doCompile') || $params->get('loadcompiledcss', '0') == '0') {
						$itemcss = self::injectItemCss($item, $menuID, $params);
						if ($itemcss) {
							if ($params->get('loadcompiledcss', '0') == '0') {
								$document->addStyleDeclaration($itemcss);
							} else {
								self::$_itemcss .= $itemcss;
							}
						}
					}
				}

				$lastitem = $i;
			} // end of boucle for each items

			// give the correct deep infos for the last item
			if (isset($items[$lastitem])) {
				$items[$lastitem]->deeper = (($start ? $start : 1) > $items[$lastitem]->level);
				$items[$lastitem]->shallower = (($start ? $start : 1) < $items[$lastitem]->level);
				$items[$lastitem]->level_diff = ($items[$lastitem]->level - ($start ? $start : 1));
			}
//			$cache->store($items, $key);
//		}

		return $items;
	}

	/**
	 * Get a the parent item object
	 *
	 * @param Object $id The current item
	 * @param Array $items The list of all items
	 *
	 * @return object
	 */
	static function getParentItem($id, $items) {
		foreach ($items as $item) {
			if ($item->id == $id)
				return $item;
		}
		return new stdClass();
	}

	/**
	 * Get base menu item.
	 *
	 * @param   JRegistry  &$params  The module options.
	 *
	 * @return   object
	 *
	 * @since	3.0.2
	 */
	public static function getBase($params)
	{
		// Get base menu item from parameters
		if ($params->get('base'))
		{
			$base = JFactory::getApplication()->getMenu()->getItem($params->get('base'));
		}
		else
		{
			$base = false;
		}

		// Use active menu item if no base found
		if (!$base)
		{
			$base = self::getActive();
		}

		return $base;
	}

	/**
	 * Get active menu item.
	 *
	 * @param   JRegistry  &$params  The module options.
	 *
	 * @return  object
	 *
	 * @since	3.0.2
	 */
	public static function getActive()
	{
		$menu = JFactory::getApplication()->getMenu();

		return $menu->getActive() ? $menu->getActive() : $menu->getDefault();
	}

	/**
	 * Get the css from the theme php file and write them into a css file.
	 *
	 * @param   string  $filetocompile  The path to the theme php file.
	 * @param   JRegistry  &$params  The module options.
	 *
	 * @return  true on success
	 *
	 */
	public static function getCompiledCss($params) {
		/*
		$theme = $params->get('theme', 'default');
		$themeFile = JPATH_ROOT . '/modules/mod_accordeonmenuck/themes/' . $theme . '/css/accordeonmenuck.php';
		$phpcss = '';
		if (file_exists($themeFile)) {
			$phpcss = file_get_contents($themeFile);
		}
		$menuID = $params->get('menuid', '');
		$css = str_replace('<?php echo $id; ?>', $menuID, $phpcss);
		$pattern = '/<\?php\s[^>]*[^>]*(.*)\?>/iUs';
		$replacement = '';
		$css = preg_replace($pattern, $replacement, $css);
		*/
		$css = '';
		// add the menu items css
		if (self::$_modulecss) {
			$css .= '

.clr {clear:both;visibility : hidden;}

/*---------------------------------------------
---	 Module styles from Accordeon Menu CK   ---
----------------------------------------------*/
';
			$css .= str_replace(array(";", "{"), array(";\n\t", "{\n\t"), self::$_modulecss); // add new line and tab for reading purpose
		}

		// add the menu items css
		if (self::$_itemcss) {
			$css .= '
				
/*---------------------------------------------
---	 Menu items	styles Accordeon Menu CK ---
----------------------------------------------*/
';
			$css .= str_replace(array(";", "{"), array(";\n\t", "{\n\t"), self::$_itemcss); // add new line and tab for reading purpose
		}
		// $cssfile = dirname(__FILE__) . '/themes/custom/css/accordeonmenuck_' . $menuID . '.css';
		// if (! JFolder::exists(dirname(__FILE__) . '/themes/custom/css/')) {
			// JFolder::create(dirname(__FILE__) . '/themes/custom/css/');
		// }
		// return JFile::write($cssfile, $css);

		return $css;
	}

	/**
	 * Create the css properties
	 *
	 * @return Array
	 */
	static function injectItemCss($item, $menuID, $params) {
		$itemcss = Style::createCss($menuID, $item->fparams, 'accordeonckparams_link');
		$itemcsshover = Style::createCss($menuID, $item->fparams, 'accordeonckparams_linkhover');
		$itemcssactive = Style::createCss($menuID, $item->fparams, 'accordeonckparams_linkactive');
		$css = '';

		// normal state
		if ($itemcss['padding'] || $itemcss['margin'] || $itemcss['background'] || $itemcss['borderradius'] || $itemcss['shadow'] || $itemcss['border'])
			$css .= "#" . $menuID . " li#item-" . $item->id . " { " . $itemcss['padding'] . $itemcss['margin'] . $itemcss['background'] . $itemcss['gradient'] . $itemcss['borderradius'] . $itemcss['shadow'] . $itemcss['border'] . " }\n";
		if ($itemcss['fontcolor'] || $itemcss['fontsize'])
			$css .= "#" . $menuID . " li#item-" . $item->id . " > a { " . $itemcss['fontcolor'] . $itemcss['fontsize'] . " }\n";
		if ($itemcss['descfontcolor'] || $itemcss['descfontsize'])
			$css .= "#" . $menuID . " li#item-" . $item->id . " > a span.accordeonckdesc { " . $itemcss['descfontcolor'] . $itemcss['descfontsize'] . " }\n";

		// hover state
		if ($itemcsshover['padding'] || $itemcsshover['margin'] || $itemcsshover['background'] || $itemcsshover['borderradius'] || $itemcsshover['shadow'] || $itemcsshover['border'])
			$css .= "#" . $menuID . " li#item-" . $item->id . ":hover { " . $itemcsshover['padding'] . $itemcsshover['margin'] . $itemcsshover['background'] . $itemcsshover['gradient'] . $itemcsshover['borderradius'] . $itemcsshover['shadow'] . $itemcsshover['border'] . " }\n";
		if ($itemcsshover['fontcolor'] || $itemcsshover['fontsize'])
			$css .= "#" . $menuID . " li#item-" . $item->id . ":hover > a { " . $itemcsshover['fontcolor'] . $itemcsshover['fontsize'] . " }\n";
		if ($itemcsshover['descfontcolor'] || $itemcsshover['descfontsize'])
			$css .= "#" . $menuID . " li#item-" . $item->id . ":hover > a span.accordeonckdesc { " . $itemcsshover['descfontcolor'] . $itemcsshover['descfontsize'] . " }\n";

		// active state
		if ($itemcssactive['padding'] || $itemcssactive['margin'] || $itemcssactive['background'] || $itemcssactive['borderradius'] || $itemcssactive['shadow'] || $itemcssactive['border'])
			$css .= "#" . $menuID . " li#item-" . $item->id . ".active { " . $itemcssactive['padding'] . $itemcssactive['margin'] . $itemcssactive['background'] . $itemcssactive['gradient'] . $itemcssactive['borderradius'] . $itemcssactive['shadow'] . $itemcssactive['border'] . " }\n";
		if ($itemcssactive['fontcolor'] || $itemcssactive['fontsize'])
			$css .= "#" . $menuID . " li#item-" . $item->id . ".active > a { " . $itemcssactive['fontcolor'] . $itemcssactive['fontsize'] . " }\n";
		if ($itemcssactive['descfontcolor'] || $itemcssactive['descfontsize'])
			$css .= "#" . $menuID . " li#item-" . $item->id . ".active > a span.accordeonckdesc { " . $itemcssactive['descfontcolor'] . $itemcssactive['descfontsize'] . " }\n";

		return $css;
	}
}
