<?php
/**
 * @name		Accordeon Menu CK params
 * @package		com_accordeonmenuck
 * @copyright	Copyright (C) 2016. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

// no direct access
defined('_JEXEC') or die;
if (! defined('CK_LOADED')) define('CK_LOADED', 1);

include_once JPATH_ADMINISTRATOR . '/components/com_accordeonmenuck/helpers/defines.php';

// Access check.
if (!JFactory::getUser()->authorise('core.edit', 'com_accordeonmenuck')) {
	return JError::raiseWarning(404, JText::_('JERROR_ALERTNOAUTHOR'));
}

// loads the language files from the frontend
$lang	= JFactory::getLanguage();
$lang->load('com_accordeonmenuck', JPATH_SITE . '/components/com_accordeonmenuck', $lang->getTag(), false);
$lang->load('com_accordeonmenuck', JPATH_SITE, $lang->getTag(), false);

// loads the helper in any case
require_once ACCORDEONMENUCK_PATH . '/helpers/cktext.php';
require_once ACCORDEONMENUCK_PATH . '/helpers/ckpath.php';
require_once ACCORDEONMENUCK_PATH . '/helpers/ckfile.php';
require_once ACCORDEONMENUCK_PATH . '/helpers/ckfolder.php';
require_once ACCORDEONMENUCK_PATH . '/helpers/ckuri.php';
require_once ACCORDEONMENUCK_PATH . '/helpers/ckfof.php';
require_once ACCORDEONMENUCK_PATH . '/helpers/helper.php';
require_once ACCORDEONMENUCK_PATH . '/helpers/ckframework.php';
require_once ACCORDEONMENUCK_PATH . '/helpers/ckcontroller.php';
require_once ACCORDEONMENUCK_PATH . '/helpers/ckmodel.php';
require_once ACCORDEONMENUCK_PATH . '/helpers/ckview.php';

\Accordeonmenuck\CKFramework::load();

// Include dependancies
require_once ACCORDEONMENUCK_PATH . '/controller.php';

$controller	= \Accordeonmenuck\CKController::getInstance('Accordeonmenuck');
//if (!JFactory::getApplication()->input->get('view')) JFactory::getApplication()->input->set('view','modules');
$controller->execute(JFactory::getApplication()->input->get('task'));
//$controller->redirect();
