<?php
// No direct access
defined('_JEXEC') or die('Restricted access');

use Accordeonmenuck\CKView;
use Accordeonmenuck\CKFof;
use Accordeonmenuck\CKInterface;

class AccordeonmenuckViewStyle extends CKView
{
	protected $params;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$user = JFactory::getUser();
		$authorised = ($user->authorise('core.edit', 'com_accordeonmenuck') || (count($user->getAuthorisedCategories('com_accordeonmenuck', 'core.edit'))));

		if ($authorised !== true)
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
			return false;
		}

		// load the module params
		$moduleId = $this->input->get('frommoduleid', 0, 'int');
		$module = CKFof::dbLoad('#__modules', $moduleId);
		$this->params = new JRegistry($module->params);

		// get the interface
		require_once(JPATH_SITE . '/administrator/components/com_accordeonmenuck/helpers/ckinterface.php');
		$this->interface = new \Accordeonmenuck\CKInterface();

		$this->item = $this->get('Item');

		// get the custom css from the V8 module if needed
		if ($moduleId && !$this->item->customcss) {
			$this->item->customcss = $this->params->get('customcss');
		}

		// force the layout
		$this->input->set('tmpl', 'component');

		$tpl = $this->input->get('layout', $tpl);
		$this->input->set('layout', 'modal');

		parent::display($tpl);
		// for rendering the ajax layout
		if ($tpl == 'edit_render_menu_module') exit();
	}

	/**
	 * B/C function to load the layout file
	 * @param type $file
	 */
	public function loadTemplate($file) {
		require dirname(__FILE__) . '/tmpl/edit_' . $file . '.php';
	}
}
