<?php
// No direct access
defined('_JEXEC') or die('Restricted access');

use Accordeonmenuck\CKFof;
use Accordeonmenuck\CKFramework;
use Accordeonmenuck\Helper;
use Accordeonmenuck\Style;

require_once(ACCORDEONMENUCK_PATH . '/helpers/defines.js.php');
require_once(ACCORDEONMENUCK_PATH . '/helpers/style.php');

CKFramework::load();
CKFramework::loadFaIconsInline();
Helper::loadCkbox();

$this->imagespath = ACCORDEONMENUCK_MEDIA_URI .'/images';
$this->colorpicker_class = 'color {required:false,pickerPosition:\'top\',pickerBorder:2,pickerInset:3,hash:true}';

CKFof::addStylesheet(ACCORDEONMENUCK_MEDIA_URI . '/assets/admin.css');
CKFof::addScript(ACCORDEONMENUCK_MEDIA_URI . '/assets/jscolor/jscolor.js');
CKFof::addScript(ACCORDEONMENUCK_MEDIA_URI . '/assets/admin.js?ver=2.0.4');
CKFof::addScript(ACCORDEONMENUCK_MEDIA_URI . '/assets/style.js');
CKFof::addScript(ACCORDEONMENUCK_MEDIA_URI . '/assets/accordeonmenuck.js');

$layout = $this->input->get('layout', '', 'string');
$popupclass = ($layout === 'modal') ? 'ckpopupwizard' : '';
$preview_width = ($this->params->get('orientation', 'horizontal') == 'vertical') ? 'width:200px;' : 'width:300px;';
$theme = $this->params->get('theme', 'default');
if ($theme != -1) {
	$themecss = file_get_contents(JPATH_ROOT . '/modules/mod_accordeonmenuck/themes/' . $theme . '/css.php');
	$themecss = str_replace('<?php echo $id; ?>', 'accordeonmenuck_previewmodule', $themecss);
} else {
	$themecss = '';
}
$moduleId = $this->input->get('frommoduleid', 0, 'int');
?>
<style>
#stylescontainer {
	display: flex;
}

#stylescontainerleft, #stylescontainerright {
	/*float :left;*/
	width: auto;
	padding: 10px;
	box-sizing: border-box;
}

#stylescontainerleft {
	width: 810px;
}

#stylescontainerright {
	width: calc(100% - 850px);
	min-width: 400px;
}

body.contentpane {
	padding-top: 66px;
}

#accordeonmenuck_previewmodule.accordeonmenuckh {
	min-width: 600px;
}

.istopfixed {
	width: 600px;
	right: 10px;
}
</style>

<div class="menustylescustom" data-prefix="menustyles" data-rule="[menustyles]"></div>
<div class="menustylescustom" data-prefix="level1itemnormalstyles" data-rule="[level1itemnormalstyles]"></div>
<div class="menustylescustom" data-prefix="level1itemhoverstyles" data-rule="[level1itemhoverstyles]"></div>
<div class="menustylescustom" data-prefix="level1itemactivestyles" data-rule="[level1itemactivestyles]"></div>
<div class="menustylescustom" data-prefix="level1itemparentstyles" data-rule="[level1itemparentstyles]"></div>
<div class="menustylescustom" data-prefix="level2menustyles" data-rule="[level2menustyles]"></div>
<div class="menustylescustom" data-prefix="level2itemnormalstyles" data-rule="[level2itemnormalstyles]"></div>
<div class="menustylescustom" data-prefix="level2itemhoverstyles" data-rule="[level2itemhoverstyles]"></div>
<div class="menustylescustom" data-prefix="level2itemactivestyles" data-rule="[level2itemactivestyles]"></div>
<div class="menustylescustom" data-prefix="level1itemnormalstylesicon" data-rule="[level1itemnormalstylesicon]"></div>
<div class="menustylescustom" data-prefix="level1itemhoverstylesicon" data-rule="[level1itemhoverstylesicon]"></div>
<div class="menustylescustom" data-prefix="level2itemnormalstylesicon" data-rule="[level2itemnormalstylesicon]"></div>
<div class="menustylescustom" data-prefix="level2itemhoverstylesicon" data-rule="[level2itemhoverstylesicon]"></div>
<div class="menustylescustom" data-prefix="level3menustyles" data-rule="[level3menustyles]"></div>
<div class="menustylescustom" data-prefix="level3itemnormalstyles" data-rule="[level3itemnormalstyles]"></div>
<div class="menustylescustom" data-prefix="level3itemhoverstyles" data-rule="[level3itemhoverstyles]"></div>
<div class="menustylescustom" data-prefix="headingstyles" data-rule="[headingstyles]"></div>
<div class="menustylescustom" data-prefix="fancystyles" data-rule="[fancystyles]"></div>

<div id="ckpopupstyleswizard" class="<?php echo $popupclass; ?>">
<input type="hidden" id="id" name="id" value="<?php echo $this->item->id; ?>" />
	<input type="hidden" id="layoutcss" name="layoutcss" value="<?php echo $this->item->layoutcss; ?>" />
	<input type="hidden" id="params" name="params" value="<?php echo htmlspecialchars($this->item->params); ?>" />
	<input type="hidden" id="returnFunc" name="returnFunc" value="<?php echo htmlspecialchars($this->input->get('returnFunc', '', 'cmd')); ?>" />
	<input type="hidden" id="frommoduleid" name="frommoduleid" value="<?php echo $moduleId; ?>" />
	<?php
	// detection for IE
	if(strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== FALSE || strpos($_SERVER['HTTP_USER_AGENT'], 'Trident/7.0; rv:11.0') !== FALSE ) { ?>
	<div class="errorck" style="margin:0 10px;">
		<?php echo JText::_('CK_PLEASE_DO_NOT_USE_IE'); ?>
	</div>
	<?php } ?>
	
	<div id="stylescontainer" style="min-width: 1300px;" class="animateck">
		<div id="stylescontainerleft" class="ckinterface">
		<?php if ($moduleId > 0) { 
			$this->item->name = $this->item->name ? $this->item->name : 'moduleid' . $moduleId;
		?>
			<input type="hidden" id="name" name="name" value="<?php echo $this->item->name; ?>" />
		<?php } else { ?>
			<label for="name" style="display: inline-block;"><?php echo JText::_('CK_NAME'); ?></label>
			<input type="text" id="name" name="name" value="<?php echo $this->item->name; ?>" />
		<?php } ?>
			<div id="styleswizard_options" class="styleswizard">
				<div class="ckinterfacetablink current" data-level="1" data-tab="tab_mainmenu" data-group="main"><?php echo JText::_('CK_MAINMENU'); ?></div>
				<div class="ckinterfacetablink" data-level="1" data-tab="tab_submenu" data-group="main"><?php echo JText::_('CK_SUBMENU'); ?></div>
				<div class="ckinterfacetablink" data-level="1" data-tab="tab_subsubmenu" data-group="main"><?php echo JText::_('CK_SUBSUBMENU'); ?></div>
				<div class="ckinterfacetablink" data-level="1" data-tab="tab_customcss" data-group="main"><?php echo JText::_('CK_CUSTOM_CSS'); ?></div>
				<div class="ckinterfacetablink" data-level="1" data-tab="tab_presets" data-group="main"><?php echo JText::_('CK_PRESETS'); ?></div>
				<div class="ckclr"></div>
				<div class="ckinterfacetab current hascol" data-level="1" id="tab_mainmenu" data-group="main">
					<div class="ckcol_left">
						<div class="ckinterfacetablink current" data-tab="tab_menustyles" data-group="mainmenu"><?php echo JText::_('CK_MENUBAR'); ?></div>
						<div class="ckinterfacetablink" data-tab="tab_level1itemgroup" data-group="mainmenu"><?php echo JText::_('CK_LINKS_GROUP'); ?></div>
						<div class="ckinterfacetablink" data-tab="tab_level1itemnormalstyles" data-group="mainmenu"><?php echo JText::_('CK_MENULINK'); ?></div>
						<div class="ckinterfacetablink" data-tab="tab_level1itemhoverstyles" data-group="mainmenu"><?php echo JText::_('CK_MENULINK_HOVER'); ?></div>
						<div class="ckinterfacetablink" data-tab="tab_level1itemactivestyles" data-group="mainmenu"><?php echo JText::_('CK_MENULINK_ACTIVE'); ?></div>
						<div class="ckinterfacetablink" data-tab="tab_level1itemparentarrow" data-group="mainmenu"><?php echo JText::_('CK_PARENT_ARROW'); ?></div>
					</div>
					<div class="ckcol_right">
						<div class="ckinterfacetab current" id="tab_menustyles" data-group="mainmenu">
							<div class="ckheading"><?php echo JText::_('CK_TEXT_LABEL'); ?></div>
							<?php include dirname(__FILE__) . '/edit_render_tab_menustyles.php' ?>
							<div class="ckheading"><?php echo JText::_('CK_APPEARANCE_LABEL'); ?></div>
							<?php
							$this->interface->createBackgroundColor('menustyles');
							$this->interface->createBackgroundImage('menustyles');
							$this->interface->createBorders('menustyles');
							$this->interface->createRoundedCorners('menustyles');
							$this->interface->createShadow('menustyles');
							$this->interface->createTextShadow('menustyles');
							?>
							<div class="ckheading"><?php echo JText::_('CK_DIMENSIONS_LABEL'); ?></div>
							<?php
							$this->interface->createMargins('menustyles');
							?>
						</div>
						<div class="ckinterfacetab" id="tab_level1itemgroup" data-group="mainmenu">
							<?php echo Helper::getProMessage() ?>
						</div>
						<div class="ckinterfacetab" id="tab_level1itemnormalstyles" data-group="mainmenu">
							<div class="ckheading"><?php echo JText::_('CK_APPEARANCE_LABEL'); ?></div>
							<?php echo Helper::getProMessage() ?>
							<div class="ckheading"><?php echo JText::_('CK_DIMENSIONS_LABEL'); ?></div>
							<?php
							$this->interface->createMargins('level1itemnormalstyles');
							?>
						</div>
						<div class="ckinterfacetab" id="tab_level1itemhoverstyles" data-group="mainmenu">
							<?php echo Helper::getProMessage() ?>
						</div>
						<div class="ckinterfacetab" id="tab_level1itemactivestyles" data-group="mainmenu">
							<?php echo Helper::getProMessage() ?>
						</div>
						<div class="ckinterfacetab" id="tab_level1itemactivehoverstyles" data-group="mainmenu">
							<?php echo Helper::getProMessage() ?>
						</div>
						<div class="ckinterfacetab" id="tab_level1itemparentarrow" data-group="mainmenu">
							<?php include dirname(__FILE__) . '/edit_render_tab_level1itemparentarrow.php' ?>
						</div>
						<div class="ckinterfacetab" id="tab_level1itemparentstyles" data-group="mainmenu">
							<div class="ckheading"><?php echo JText::_('CK_APPEARANCE_LABEL'); ?></div>
							<?php
							$this->interface->createBorders('level1itemparentstyles');
							$this->interface->createRoundedCorners('level1itemparentstyles');
							$this->interface->createShadow('level1itemparentstyles');
							?>
							<div class="ckheading"><?php echo JText::_('CK_DIMENSIONS_LABEL'); ?></div>
							<?php
							$this->interface->createMargins('level1itemparentstyles');
							?>
						</div>
						<div class="ckinterfacetab" id="tab_level1itemicon" data-group="mainmenu">
							<?php include dirname(__FILE__) . '/edit_render_tab_level1itemicon.php' ?>
						</div>
					</div>
					<div style="clear:both;"></div>
				</div>
				<div class="ckinterfacetab hascol" data-level="1" id="tab_submenu" data-group="main">
					<div class="ckcol_left">
						<div class="ckinterfacetablink current" data-tab="tab_level2menustyles" data-group="submenu"><?php echo JText::_('CK_SUBMENU'); ?></div>
						<div class="ckinterfacetablink" data-tab="tab_level2itemgroup" data-group="submenu"><?php echo JText::_('CK_LINKS_GROUP'); ?></div>
						<div class="ckinterfacetablink" data-tab="tab_level2itemnormalstyles" data-group="submenu"><?php echo JText::_('CK_SUBMENULINK'); ?></div>
						<div class="ckinterfacetablink" data-tab="tab_level2itemhoverstyles" data-group="submenu"><?php echo JText::_('CK_SUBMENULINK_HOVER'); ?></div>
						<div class="ckinterfacetablink" data-tab="tab_level2itemactivestyles" data-group="submenu"><?php echo JText::_('CK_SUBMENULINK_ACTIVE'); ?></div>
						<div class="ckinterfacetablink" data-tab="tab_level2itemparentarrow" data-group="submenu"><?php echo JText::_('CK_PARENT_ARROW'); ?></div>
					</div>
					<div class="ckcol_right">
						<div class="ckinterfacetab current" id="tab_level2menustyles" data-group="submenu">
							<?php echo Helper::getProMessage() ?>
						</div>
						<div class="ckinterfacetab" id="tab_level2itemgroup" data-group="submenu">
							<?php echo Helper::getProMessage() ?>
						</div>
						<div class="ckinterfacetab" id="tab_level2itemnormalstyles" data-group="submenu">
							<?php echo Helper::getProMessage() ?>
						</div>
						<div class="ckinterfacetab" id="tab_level2itemhoverstyles" data-group="submenu">
							<?php echo Helper::getProMessage() ?>
						</div>
						<div class="ckinterfacetab" id="tab_level2itemactivestyles" data-group="submenu">
							<?php echo Helper::getProMessage() ?>
						</div>
						<div class="ckinterfacetab" id="tab_level2itemparentarrow" data-group="submenu">
							<?php echo Helper::getProMessage() ?>
						</div>
						<div class="ckinterfacetab" id="tab_level2heading" data-group="submenu">
							<?php echo Helper::getProMessage() ?>
						</div>
						<div class="ckinterfacetab" id="tab_level2itemicon" data-group="submenu">
							<?php echo Helper::getProMessage() ?>
						</div>
					</div>
					<div style="clear:both;"></div>
				</div>
				<div class="ckinterfacetab hascol" data-level="1" id="tab_subsubmenu" data-group="main">
					<div class="ckcol_left">
						<div class="ckinterfacetablink current" data-tab="tab_level3menustyles" data-group="submenu"><?php echo JText::_('CK_SUBMENU'); ?></div>
						<div class="ckinterfacetablink" data-tab="tab_level3itemgroup" data-group="submenu"><?php echo JText::_('CK_LINKS_GROUP'); ?></div>
						<div class="ckinterfacetablink" data-tab="tab_level3itemnormalstyles" data-group="submenu"><?php echo JText::_('CK_SUBMENULINK'); ?></div>
						<div class="ckinterfacetablink" data-tab="tab_level3itemhoverstyles" data-group="submenu"><?php echo JText::_('CK_SUBMENULINK_HOVER'); ?></div>
						<div class="ckinterfacetablink" data-tab="tab_level3itemactivestyles" data-group="submenu"><?php echo JText::_('CK_SUBMENULINK_ACTIVE'); ?></div>
						<div class="ckinterfacetablink" data-tab="tab_level3itemparentarrow" data-group="submenu"><?php echo JText::_('CK_PARENT_ARROW'); ?></div>
					</div>
					<div class="ckcol_right">
						<div class="ckinterfacetab current" id="tab_level3menustyles" data-group="submenu">
							<?php echo Helper::getProMessage() ?>
						</div>
						<div class="ckinterfacetab" id="tab_level3itemgroup" data-group="submenu">
							<?php echo Helper::getProMessage() ?>
						</div>
						<div class="ckinterfacetab" id="tab_level3itemnormalstyles" data-group="submenu">
							<?php echo Helper::getProMessage() ?>
						</div>
						<div class="ckinterfacetab" id="tab_level3itemhoverstyles" data-group="submenu">
							<?php echo Helper::getProMessage() ?>
						</div>
						<div class="ckinterfacetab" id="tab_level3itemactivestyles" data-group="submenu">
							<?php echo Helper::getProMessage() ?>
						</div>
						<div class="ckinterfacetab" id="tab_level3itemparentarrow" data-group="submenu">
							<?php echo Helper::getProMessage() ?>
						</div>
						<div class="ckinterfacetab" id="tab_level3heading" data-group="submenu">
							<?php echo Helper::getProMessage() ?>
						</div>
						<div class="ckinterfacetab" id="tab_level3itemicon" data-group="submenu">
							<?php echo Helper::getProMessage() ?>
						</div>
					</div>
					<div style="clear:both;"></div>
				</div>
				<div class="ckinterfacetab" data-level="1" id="tab_customcss" data-group="main">
					<div id="customcssbuttons">
						<div class="customcssbutton btn" data-rule="|ID| { }"><?php echo JText::_('CK_MENUBAR'); ?></div>
						<div class="customcssbutton btn" data-rule="|ID| li.accordeonck.level1 { }"><?php echo JText::_('CK_MENULINK'); ?></div>
						<div class="customcssbutton btn" data-rule="|ID| li.accordeonck.level1:hover { }"><?php echo JText::_('CK_MENULINK_HOVER'); ?></div>
						<div class="customcssbutton btn" data-rule="|ID| li.accordeonck.level1.active { }"><?php echo JText::_('CK_MENULINK_ACTIVE'); ?></div>
						<div class="customcssbutton btn" data-rule="|ID| li.accordeonck ul.accordeonck { }"><?php echo JText::_('CK_SUBMENU'); ?></div>
						<div class="customcssbutton btn" data-rule="|ID| ul.accordeonck li.accordeonck { }"><?php echo JText::_('CK_SUBMENULINK'); ?></div>
						<div class="customcssbutton btn" data-rule="|ID| ul.accordeonck li.accordeonck:hover { }"><?php echo JText::_('CK_SUBMENULINK_HOVER'); ?></div>
						<div class="customcssbutton btn" data-rule="|ID| ul.accordeonck li.accordeonck.active { }"><?php echo JText::_('CK_SUBMENULINK_ACTIVE'); ?></div>
						<div class="customcssbutton btn" data-rule="|ID| li.accordeonck ul.accordeonck ul.accordeonck { }"><?php echo JText::_('CK_SUBSUBMENU'); ?></div>
					</div>
					<textarea id="customcss" style="width: calc(100% - 20px);margin:10px;min-height:400px;box-sizing:border-box;"><?php echo $this->item->customcss; ?></textarea>
				</div>
				<div class="ckinterfacetab" data-level="1" id="tab_presets" data-group="main">
					<?php echo Helper::getProMessage() ?>
				</div>
			</div>
		</div>
		<div id="stylescontainerright">
			<div id="previewarea">
				<style class="ckstyletheme">
					<?php echo $themecss ?>
				</style>
				<div class="ckstylesheet">
					<div class="ckstylesheet">
						<?php /*<link type="text/css" href="<?php echo JUri::root(true); ?>/modules/mod_accordeonmenuck/themes/<?php echo $this->params->get('theme', 'blank'); ?>/css/accordeonmenuck.php?monid=accordeonmenuck_previewmodule" rel="stylesheet"> */ ?>
					</div>
				</div>
				<div class="ckgfontstylesheet"></div>
				<div class="ckstyle"></div>
				<div class="inner" style="<?php echo $preview_width; ?>">
					<?php echo $this->loadTemplate('render_menu_module'); ?>
				</div>
			</div>
			
		</div>
	
	
	<div style="clear:both;"></div>
</div>
<script language="javascript" type="text/javascript">
	ACCORDEONMENUCK.CKCSSREPLACEMENT = new Object();
	<?php foreach (Style::getCssReplacement() as $tag => $rep) { ?>
	ACCORDEONMENUCK.CKCSSREPLACEMENT['<?php echo $tag ?>'] = '<?php echo $rep ?>';
	<?php } ?>

	jQuery(document).ready(function($){
		// window.setInterval("ckKeepAlive()", 600000);

		CKBox.initialize({});
		CKBox.assign($('a.modal'), {
			parse: 'rel'
		});
		CKApi.Tooltip('.cktip');

		// manage the tabs
		ckInitTabs();
		// launch the preview when the user do a change
		$('#styleswizard_options input,#styleswizard_options select,#styleswizard_options textarea').change(function() {
			ckPreviewStyles(); // B/C preview_stylesparams
		});

		ckApplyStylesparams();
		ckSetFloatingOnPreview();
		// ckPlayAnimationPreview();
		
		$ck('.customcssbutton').click(function() {
			$ck('#customcss').val($ck('#customcss').val() + $ck(this).attr('data-rule'));
		});
	});
</script>
