<?php
// no direct access
defined('_JEXEC') or die;

require_once(JPATH_ROOT . '/administrator/components/com_accordeonmenuck/helpers/defines.js.php');

use Accordeonmenuck\CKFramework;
use Accordeonmenuck\CKFof;

CKFramework::load();
CKFramework::loadFaIconsInline();

$imagespath = ACCORDEONMENUCK_MEDIA_URI .'/images/';
$fieldid = $this->input->get('fieldid', '', 'string');

CKFof::addStylesheet(ACCORDEONMENUCK_MEDIA_URI . '/assets/ckbrowse.css');
CKFof::addScript(ACCORDEONMENUCK_MEDIA_URI . '/assets/ckbrowse.js');

?>
<h3><?php echo JText::_('CK_MENU_ITEMS') ?></h3>
<p><?php echo JText::_('CK_MENU_ITEMS_DESC') ?></p>
<div id="ckfoldertreelist">
<?php
foreach ($this->items as $menu) {
	?>
	<div class="ckfoldertree parent">
		<div class="ckfoldertreetoggler" onclick="ckToggleTreeSub(this, 0)" data-menutype="<?php echo $menu->menutype; ?>"></div>
		<div class="ckfoldertreename"><i class="fas fa-folder"></i><?php echo utf8_encode($menu->title); ?></div>
	</div>
	<?php
}
?>
</div>
<style>
	.ckfoldertreename .fas {
		font-size: 16px;
		margin: 5px;
		vertical-align: sub;
	}
</style>
<script>
var $ck = window.$ck || jQuery.noConflict();
var URIROOT = window.URIROOT || '<?php echo JUri::root(true) ?>';
var cktoken = '<?php echo JSession::getFormToken() ?>';
//ckMakeTooltip();

function ckToggleTreeSub(btn, parentid) {
	var item = $ck(btn).parent();
	if (item.hasClass('ckopened')) {
		item.removeClass('ckopened');
	} else {
		item.addClass('ckopened');
		// load only the items if not already there
		if (! item.find('.cksubfolder').length) {
			var menutype = $ck(btn).attr('data-menutype');
			ckShowItems(btn, menutype, parentid);
		}
	}
}

function ckShowItems(btn, menutype, parentid) {
	if ($ck(btn).hasClass('empty')) return;
	ckAddWaitIcon(btn);
	var item = $ck(btn).parent();
	// ajax call to code and return items layout
	var myurl = ACCORDEONMENUCK.BASE_URL + "&task=items.load&type=menuitem&func=ajaxShowMenuItems&" + ACCORDEONMENUCK.TOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			menutype: menutype,
			parentid: parentid
		}
	}).done(function(code) {
		if (code.trim().length == 0) {
			$ck(btn).css('opacity', 0).addClass('empty');
		} else {
			item.append(code);
			ckInitTooltips();
		}
		ckRemoveWaitIcon(btn);
	}).fail(function() {
		alert(CKApi.Text._('CK_FAILED', 'Failed'));
	});
}

function ckSetMenuItemUrl(url) {
	window.parent.document.getElementById('<?php echo $fieldid ?>').value = url;
	$ck(window.parent.document.getElementById('<?php echo $fieldid ?>')).trigger('change');
	window.parent.CKBox.close('#ckmenusmodal .ckboxmodal-button');
}
</script>