<?php
/**
 * @name		Accordeon Menu CK
 * @package		com_accordeonmenuck
 * @copyright	Copyright (C) 2014. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
 
defined('_JEXEC') or die('Restricted access');
/*
	preflight which is executed before install and update
	install
	update
	uninstall
	postflight which is executed after install and update
	*/

class com_accordeonmenuckInstallerScript {

	function install($parent) {
		
	}

	function update($parent) {
		
	}

	function uninstall($parent) {
		// disable all plugins and modules
		$db = JFactory::getDbo();
		$db->setQuery("UPDATE `#__modules` SET `published` = 0 WHERE `module` LIKE '%accordeonmenuck%'");
		$db->execute();

		$db->setQuery("UPDATE `#__extensions` SET `enabled` = 0 WHERE `type` = 'plugin' AND `element` LIKE '%accordeonmenuck%' AND `folder` NOT LIKE '%accordeonmenuck%'");
		$db->execute();
		return true;
	}

	function preflight($type, $parent) {
		// check if a pro version already installed
		$xmlPath = JPATH_ROOT . '/administrator/components/com_accordeonmenuck/accordeonmenuck.xml';

		// if no file already exists
		if (file_exists($xmlPath)) {
			$xmlData = $this->getXmlData($xmlPath);
			$isProInstalled = ((int)$xmlData->ckpro);

			if ($isProInstalled) {
				throw new RuntimeException('Accordeon Menu CK Light cannot be installed over Accordeon Menu CK Pro. Please install Accordeon Menu CK Pro. To downgrade, please first uninstall Accordeon Menu CK Pro.');
				// return false;
			}
		}

		// check if a V1 version is installed with the params (needs the pro)
		$xmlPath = JPATH_ROOT . '/modules/mod_accordeonck/mod_accordeonck.xml';

		// if no file already exists
		if (! file_exists($xmlPath)) return true;

		$xmlData = $this->getXmlData($xmlPath);
		$installedVersion = ((int)$xmlData->version );

		// if the installed version is the V1
		if(version_compare($installedVersion, '3.0.0', '<')) {
			// if the params is also installed
			if (file_exists(JPATH_ROOT . '/plugins/system/accordeonckparams/accordeonckparams.xml')) {
				throw new RuntimeException('Accordeon Menu CK Light cannot be installed over Accordeon Menu CK V2 + Params. Please install Accordeon Menu CK Pro to get the same features as previously, else you may loose your existing settings. To downgrade, please first uninstall Accordeon Menu CK Params. <a href="https://www.joomlack.fr/en/documentation/accordeon-menu-ck/297-migration-from-accordeon-menu-ck-version-2-to-version-3" target="_blank">Read more</a>');
				// return false;
			}
		}

		return true;
	}

	public function getXmlData($file) {
		if ( ! is_file($file))
		{
			return '';
		}

		$xml = simplexml_load_file($file);

		if ( ! $xml || ! isset($xml['version']))
		{
			return '';
		}

		return $xml;
	}

	// run on install and update
	function postflight($type, $parent) {
		// install modules and plugins
		jimport('joomla.installer.installer');
		$db = JFactory::getDbo();
		$status = array();
		$src_ext = dirname(__FILE__).'/administrator/extensions';
		$installer = new JInstaller;

		// check if update from v2
		$oldPath = JPATH_ROOT . '/modules/mod_accordeonck/mod_accordeonck.xml';
		if (file_exists($oldPath)) {
			echo '<div class="alert alert-danger"><b>Update from the version 2 detected!</b><br />Please read the documentation to follow the steps to update your installation. <a href="https://www.joomlack.fr/en/documentation/accordeon-menu-ck/297-migration-from-accordeon-menu-ck-version-2-to-version-3" target="_blank">Read more</a></div>';
		}

		// module
		$result = $installer->install($src_ext.'/mod_accordeonmenuck');
		$status[] = array('name'=>'Accordeon Menu CK - Module','type'=>'module', 'result'=>$result);

		// disable the old update site
		$db->setQuery("UPDATE #__update_sites SET enabled = '0' WHERE `location` = 'https://update.joomlack.fr/mod_accordeonmenuck_update.xml'");
		$result3 = $db->execute();
		// disable the old update site
		$db->setQuery("UPDATE #__update_sites SET enabled = '0' WHERE `location` = 'https://update.joomlack.fr/com_accordeonmenuck_update.xml'");
		$result4 = $db->execute();
		// disable the light update site
		$db->setQuery("UPDATE #__update_sites SET enabled = '0' WHERE `location` = 'https://update.joomlack.fr/accordeonmenuck_light_update.xml'");
		$result3 = $db->execute();

		foreach ($status as $statu) {
			if ($statu['result'] == true) {
				$alert = 'success';
				$icon = 'icon-ok';
				$text = 'Successful';
			} else {
				$alert = 'warning';
				$icon = 'icon-cancel';
				$text = 'Failed';
			}
			echo '<div class="alert alert-' . $alert . '"><i class="icon ' . $icon . '"></i>Installation and activation of the <b>' . $statu['type'] . ' ' . $statu['name'] . '</b> : ' . $text . '</div>';
		}

		// check for table creation
		require_once JPATH_ROOT . '/administrator/components/com_accordeonmenuck/helpers/helper.php';
		Accordeonmenuck\Helper::checkDbIntegrity();

		// check if the demo data have already been installed
		// $db->clear();
		$check = "SELECT id FROM #__accordeonmenuck_styles WHERE id = '1'";
		$db->setQuery($check);
		$exists = $db->loadResult();
		// if not, then install it
		if (! $exists) {
			$sqlInsert = file_get_contents(dirname(__FILE__) . '/administrator/sql/install.style.sql');
			// $db->clear();
			$db->setQuery($sqlInsert);
			$db->execute();
		}
		
		// check if this is a new install (only 1 style exists)
		// $db->clear();
		$db->setQuery("SELECT id FROM #__accordeonmenuck_styles");
		$existingStyles = $db->loadObjectList();
		if (count($existingStyles) == 1) {
		
			// $db->clear();
			$db->setQuery("SELECT params FROM #__modules WHERE module = 'mod_accordeonck'");
			$oldModules = $db->loadObjectList();
			if (! empty($oldModules)) {
				require_once JPATH_ROOT . '/administrator/components/com_accordeonmenuck/helpers/style.php';
				// set the prefixes for all xml fieldset
				$prefixes = array(
					'menustyles',
					'level1itemgroup',
					'level1itemnormalstyles',
					'level1itemhoverstyles',
					'level1itemactivestyles',
					'level1itemactivehoverstyles',
					'level1itemparentstyles',
					'level2menustyles',
					'level2itemgroup',
					'level2itemnormalstyles',
					'level2itemhoverstyles',
					'level2itemactivestyles',
					'level1itemnormalstylesicon',
					'level1itemhoverstylesicon',
					'level2itemnormalstylesicon',
					'level2itemhoverstylesicon',
					'level3menustyles',
					'level3itemgroup',
					'level3itemnormalstyles',
					'level3itemhoverstyles',
					'level3itemactivestyles',
					'level3itemnormalstylesicon',
					'level3itemhoverstylesicon',
					'headingstyles',
					'customcss');
					
				foreach ($oldModules as $oldModule) {
					$params = json_decode($oldModule->params);
					$importedStyles = new stdClass();
					foreach ($prefixes as $prefix) {
						if (isset($params->$prefix)) {
							
							$styles = json_decode(str_replace('|qq|', '"', $params->$prefix));
							if (! empty($styles)) {
								foreach($styles as $style) {
									$importedStyles->{$style->id} = $style->value;
								}
							}
						}
					}
					$fields = json_encode($importedStyles);
					$fields = Accordeonmenuck\Style::updateInterface($fields);
					// insert into the DB
					// $db->clear();
					$insert = "INSERT INTO #__accordeonmenuck_styles (`id`, `name`, `state`, `params`, `layoutcss`, `customcss`, `checked_out`) VALUES"
						." (0, 'imported', 0, '" . addslashes($fields) . "', '', '', '')";
					$db->setQuery($insert);
					$db->execute();
				}
			}
		}

		return true;
	}
}
