<?php
Namespace Accordeonmenuck;

// No direct access
defined('_JEXEC') or die;

require_once JPATH_ADMINISTRATOR . '/components/com_accordeonmenuck/helpers/defines.php';

use Accordeonmenuck\CKInput;
use Accordeonmenuck\CKFof;
use Accordeonmenuck\CKText;

/**
 * Helper Class.
 */
class Style {

	static $cssreplacements;

	static function createModuleCss($params, $menuID) {
		$document = \JFactory::getDocument();

		// set the prefixes for all xml fieldset
		$prefixes = array('menustyles',
			'level1itemgroup',
			'level1itemnormalstyles',
			'level1itemhoverstyles',
			'level1itemactivestyles',
			'level1itemactivehoverstyles',
			'level1itemparentstyles',
			'level2menustyles',
			'level2itemgroup',
			'level2itemnormalstyles',
			'level2itemhoverstyles',
			'level2itemactivestyles',
			'level1itemnormalstylesicon',
			'level1itemhoverstylesicon',
			'level2itemnormalstylesicon',
			'level2itemhoverstylesicon',
			'level3menustyles',
			'level3itemgroup',
			'level3itemnormalstyles',
			'level3itemhoverstyles',
			'fancystyles',
			'headingstyles');

		$css = new \stdClass();
		$csstoinject = '';
		$important = false;
		$fields = Array();

		// create the css rules for each prefix
		foreach ($prefixes as $prefix) {
			$param = $params->get($prefix, '[]');
			$objs = json_decode(str_replace("|qq|", "\"", $param));
			$fields[$prefix] = new CkCssParams();

			if (!$objs)
				continue;

			foreach ($objs as $obj) {
				$fieldid = str_replace($prefix . "_", "", $obj->id);
				$fields[$prefix]->$fieldid = isset($obj->value) ? $obj->value : null;
			}

			if ($prefix == 'headingstyles') {
				$important = true;
			}
			$css->$prefix = self::createCss($menuID, $fields[$prefix], $prefix, $important, '');
		}

		$csstoinject = '';

		// get the css suffix for the module
//		$menu_class = ( $params->get('orientation', 'horizontal') === 'horizontal' ) ? '.accordeonmenuckh' : '.accordeonmenuckv';

//		switch (trim($params->get('layout', 'default'), '_:')) {
//			case 'flatlist':
//				$menu_begin = ' ul.accordeonmenuck2';
//				break;
//			case 'nativejoomla':
//				$menu_begin = ' ul';
//				break;
//			default:
//			case 'default':
//				$menu_begin = ' ul.accordeonmenuck';
//				break;
//		}

		// set the specific menu ID to give more weight to the css rule
//		$menuCSSID = $menuID . $menu_class . $menu_begin;
		$menuCSSID = $menuID;
//		$level1 = $params->get('calledfromlevel','') ? 'level' . (string)$params->get('calledfromlevel') : 'level1';
//		$level2 = $params->get('calledfromlevel','') ? 'level' . (string)($params->get('calledfromlevel') + 1) : 'level2';

		// load the google font
		$gfont = $fields['menustyles']->get('menustylestextgfont', '');
		$isGfont = $fields['menustyles']->get('menustylestextisgfont', '1');

		if ($gfont) {
			$gfontfamily = self::get_gfontfamily($gfont);
			if ($isGfont) $document->addStylesheet('https://fonts.googleapis.com/css?family=' . $gfont);
			$csstoinject .= "div#" . $menuID . " li > a, div#" . $menuID . " li > span { font-family: '" . $gfontfamily . "';}";
		}
		$gfont = $fields['level2itemnormalstyles']->get('level2itemnormalstylestextgfont', '');
		$isGfont = $fields['level2itemnormalstyles']->get('level2itemnormalstylestextisgfont', '1');
		if ($gfont) {
			$gfontfamily = self::get_gfontfamily($gfont);
			if ($isGfont) $document->addStylesheet('https://fonts.googleapis.com/css?family=' . $gfont);
			$csstoinject .= "div#" . $menuID . " ul.accordeonmenuck2 li > a, div#" . $menuID . " ul.accordeonmenuck2 li > span { font-family: '" . $gfontfamily . "';}";
		}

		// root styles
		if (isset($css->menustyles)) {
//			if ($menupadding || $menumargin || $css->menustyles['background'] || $css->menustyles['gradient'] || $css->menustyles['borderradius'] || $css->menustyles['shadow'] || $css->menustyles['border'] || $css->menustyles['text-align']
//			) {
				$csstoinject .= "\n#" . $menuID . " { padding:0;margin:0;" . $css->menustyles['padding'] . $css->menustyles['margin'] . $css->menustyles['background'] . $css->menustyles['gradient'] . $css->menustyles['borderradius'] . $css->menustyles['shadow'] . $css->menustyles['border'] . $css->menustyles['text-align'] . " } ";
//			}
		}

		$imageposition = isset($fields['menustyles']->menustylesparentarrowposition) ? $fields['menustyles']->menustylesparentarrowposition : 'right';
		
		// level 1
		$level1imageplus = isset($fields['menustyles']->menustylesimageplus) ? $fields['menustyles']->menustylesimageplus : '';
		$level1imageminus = isset($fields['menustyles']->menustylesimageminus) ? $fields['menustyles']->menustylesimageminus : '';
		$level1imagepadding = isset($fields['menustyles']->menustylesparentarrowwidth) && $fields['menustyles']->menustylesparentarrowwidth ? 'padding-' . $imageposition . ': ' . Helper::testUnit($fields['menustyles']->menustylesparentarrowwidth) . ';' : '';
		$level1imagewidth = isset($fields['menustyles']->menustylesparentarrowwidth) && $fields['menustyles']->menustylesparentarrowwidth ? 'width: ' . Helper::testUnit($fields['menustyles']->menustylesparentarrowwidth) . ';' : '';

		// level 2
		$level2imageplus = isset($fields['level2menustyles']->level2menustylesimageplus) ? $fields['level2menustyles']->level2menustylesimageplus : '';
		$level2imageminus = isset($fields['level2menustyles']->level2menustylesimageminus)  ?$fields['level2menustyles']->level2menustylesimageminus : '';
		$level2imagepadding = isset($fields['level2menustyles']->level2menustylesparentarrowwidth) ? 'padding-' . $imageposition . ': ' . Helper::testUnit($fields['level2menustyles']->level2menustylesparentarrowwidth) . ';' : '';
		$level2imagewidth = isset($fields['level2menustyles']->level2menustylesparentarrowwidth) ? 'width: ' . Helper::testUnit($fields['level2menustyles']->level2menustylesparentarrowwidth) . ';' : '';

		// level 3
		$level3imageplus = isset($fields['level3menustyles']->level3menustylesimageplus) ? $fields['level3menustyles']->level3menustylesimageplus : '';
		$level3imageminus = isset($fields['level3menustyles']->level3menustylesimageminus) ? $fields['level3menustyles']->level3menustylesimageminus : '';
		$level3imagepadding = isset($fields['level3menustyles']->level3menustylesparentarrowwidth) ? 'padding-' . $imageposition . ': ' . Helper::testUnit($fields['level3menustyles']->level3menustylesparentarrowwidth) . ';' : '';
		$level3imagewidth = isset($fields['level3menustyles']->level3menustylesparentarrowwidth) ? 'width: ' . Helper::testUnit($fields['level3menustyles']->level3menustylesparentarrowwidth) . ';' : '';

		// base styles
		$csstoinject .= "\n#" . $menuID . " li.accordeonck { list-style: none;overflow: hidden; }";
		$csstoinject .= "\n#" . $menuID . " ul[class^=\"content\"] { margin:0;padding:0; }";
		$csstoinject .= "\n#" . $menuID . " li.accordeonck > span { position: relative; display: block; " . $css->menustyles['fontfamily'] . "}";
		$csstoinject .= "\n#" . $menuID . " li.accordeonck.parent > span { " . $level1imagepadding . "}";
		$csstoinject .= "\n#" . $menuID . " li.parent > span span.toggler_icon { position: absolute; cursor: pointer; display: block; height: 100%; z-index: 10;" . $imageposition . ":0; background: url(" . \JUri::root(true) . '/' . $level1imageplus . ") center center no-repeat !important;" . $level1imagewidth . "}";
		$csstoinject .= "\n#" . $menuID . " li.parent.open > span span.toggler_icon { " . $imageposition . ":0; background: url(" . \JUri::root(true) . '/' . $level1imageminus . ") center center no-repeat !important;}";
		$csstoinject .= "\n#" . $menuID . " li.accordeonck.level2 > span { " . $level2imagepadding . "}";
		$csstoinject .= "\n#" . $menuID . " li.level3 li.accordeonck > span { " . $level3imagepadding . "}";
		$csstoinject .= "\n#" . $menuID . " a.accordeonck { display: block;text-decoration: none; " . $css->level1itemnormalstyles['text-align'] . $css->level1itemnormalstyles['fontcolor'] . $css->level1itemnormalstyles['fontsize'] . $css->level1itemnormalstyles['fontweight'] . "}";
		$csstoinject .= "\n#" . $menuID . " a.accordeonck:hover { text-decoration: none; " . $css->level1itemhoverstyles['fontcolor'] . "}";
		$csstoinject .= "\n#" . $menuID . " li.parent > span a { display: block;outline: none; }";
		$csstoinject .= "\n#" . $menuID . " li.parent.open > span a {  }";
		$csstoinject .= "\n#" . $menuID . " a.accordeonck > .badge { margin: 0 0 0 5px; }";
		if ($level2imageplus) $csstoinject .= "\n#" . $menuID . " li.level2.parent > span a { display: block;outline: none;background: url(" . \JUri::root(true) . '/' . $level2imageplus . ") " . $imageposition . " center no-repeat !important; " . $level12magewidth . "}";
		if ($level2imageminus) $csstoinject .= "\n#" . $menuID . " li.level2.parent.open > span a { background: url(" . \JUri::root(true) . '/' . $level2imageminus . ") " . $imageposition . " center no-repeat !important; }";
		if ($level3imageplus) $csstoinject .= "\n#" . $menuID . " li.level2 li.accordeonck.parent > span a { display: block;outline: none;background: url(" . \JUri::root(true) . '/' . $level3imageplus . ") " . $imageposition . " center no-repeat !important; " . $level3imagewidth . "}";
		if ($level3imageminus) $csstoinject .= "\n#" . $menuID . " li.level2 li.accordeonck.open.parent > span a { background: url(" . \JUri::root(true) . '/' . $level3imageminus . ") " . $imageposition . " center no-repeat !important; }";

		// level 1 styles
		if (isset($css->level1itemgroup)) {
			if ($css->level1itemgroup['padding'] || $css->level1itemgroup['margin'] || $css->level1itemgroup['background'] || $css->level1itemgroup['gradient'] || $css->level1itemgroup['borderradius'] || $css->level1itemgroup['shadow'] || $css->level1itemgroup['border']
					) {
				$csstoinject .= "\n#" . $menuID . " li.level1 { " . $css->level1itemgroup['padding'] . $css->level1itemgroup['margin'] . $css->level1itemgroup['background'] . $css->level1itemgroup['gradient'] . $css->level1itemgroup['borderradius'] . $css->level1itemgroup['shadow'] . $css->level1itemgroup['border'] . " } ";
			}
		}

		// level 1 styles
		if (isset($css->level1itemnormalstyles)) {
			if ($css->level1itemnormalstyles['padding'] || $css->level1itemnormalstyles['margin'] || $css->level1itemnormalstyles['background'] || $css->level1itemnormalstyles['gradient'] || $css->level1itemnormalstyles['borderradius'] || $css->level1itemnormalstyles['shadow'] || $css->level1itemnormalstyles['border'] || $css->level1itemnormalstyles['text-align']
				|| $css->level1itemnormalstyles['fontfamily'] || $css->level1itemnormalstyles['fontcolor'] || $css->level1itemnormalstyles['fontweight'] || $css->level1itemnormalstyles['fontsize'] || $css->level1itemnormalstyles['textshadow'] || $css->level1itemnormalstyles['text-transform']
					) {
				$csstoinject .= "\n#" . $menuID . " li.level1 > span { " . $css->level1itemnormalstyles['margin'] . $css->level1itemnormalstyles['background'] . $css->level1itemnormalstyles['gradient'] . $css->level1itemnormalstyles['borderradius'] . $css->level1itemnormalstyles['shadow'] . $css->level1itemnormalstyles['border'] . " } ";
				$csstoinject .= "\n#" . $menuID . " li.level1 > span a { " . $css->level1itemnormalstyles['padding'] . $css->level1itemnormalstyles['fontcolor'] . $css->level1itemnormalstyles['fontsize'] . $css->level1itemnormalstyles['textshadow'] . $css->level1itemnormalstyles['text-align'] . $css->level1itemnormalstyles['text-transform'] . $css->level1itemnormalstyles['fontweight'] . " } ";
			}
			if ($css->level1itemnormalstyles['descfontcolor'] || $css->level1itemnormalstyles['descfontsize']
			) {
				$csstoinject .= "\n#" . $menuID . " li.level1 > span span.accordeonckdesc { " . $css->level1itemnormalstyles['descfontcolor'] . $css->level1itemnormalstyles['descfontsize'] . " } ";
			}
		}

		// level 1 styles
		if (isset($css->level1itemhoverstyles)) {
			if ($css->level1itemhoverstyles['padding'] || $css->level1itemhoverstyles['margin'] || $css->level1itemhoverstyles['background'] || $css->level1itemhoverstyles['gradient'] || $css->level1itemhoverstyles['borderradius'] || $css->level1itemhoverstyles['shadow'] || $css->level1itemhoverstyles['border'] || $css->level1itemhoverstyles['text-align']
				|| $css->level1itemhoverstyles['fontcolor'] || $css->level1itemhoverstyles['fontsize'] || $css->level1itemhoverstyles['textshadow']
					) {
				$csstoinject .= "\n#" . $menuID . " li.level1:hover > span { " . $css->level1itemhoverstyles['margin'] . $css->level1itemhoverstyles['background'] . $css->level1itemhoverstyles['gradient'] . $css->level1itemhoverstyles['borderradius'] . $css->level1itemhoverstyles['shadow'] . $css->level1itemhoverstyles['border'] . " } ";
				$csstoinject .= "\n#" . $menuID . " li.level1:hover > span a { " . $css->level1itemhoverstyles['padding'] . $css->level1itemhoverstyles['text-align'] . $css->level1itemhoverstyles['fontfamily'] . $css->level1itemhoverstyles['fontcolor'] . $css->level1itemhoverstyles['fontsize'] . $css->level1itemhoverstyles['textshadow'] . $css->level1itemhoverstyles['text-align'] . $css->level1itemhoverstyles['text-transform'] . $css->level1itemhoverstyles['fontweight'] . " } ";
				$csstoinject .= "\n#" . $menuID . " li.level1.active > span { " . $css->level1itemhoverstyles['margin'] . $css->level1itemhoverstyles['background'] . $css->level1itemhoverstyles['gradient'] . $css->level1itemhoverstyles['borderradius'] . $css->level1itemhoverstyles['shadow'] . $css->level1itemhoverstyles['border'] . " } ";
				$csstoinject .= "\n#" . $menuID . " li.level1.active > span a { " . $css->level1itemhoverstyles['padding'] . $css->level1itemhoverstyles['fontfamily'] . $css->level1itemhoverstyles['fontcolor'] . $css->level1itemhoverstyles['fontsize'] . $css->level1itemhoverstyles['textshadow'] . $css->level1itemhoverstyles['text-align'] . $css->level1itemhoverstyles['text-transform'] . $css->level1itemhoverstyles['fontweight'] . " } ";
			}
			if ($css->level1itemhoverstyles['descfontcolor'] || $css->level1itemhoverstyles['descfontsize']
			) {
				$csstoinject .= "\n#" . $menuID . " li.level1:hover > span span.accordeonckdesc { " . $css->level1itemhoverstyles['descfontcolor'] . $css->level1itemhoverstyles['descfontsize'] . " } ";
				$csstoinject .= "\n#" . $menuID . " li.level1.active > span span.accordeonckdesc { " . $css->level1itemhoverstyles['descfontcolor'] . $css->level1itemhoverstyles['descfontsize'] . " } ";
			}
		}

		// level 1 styles
		if (isset($css->level1itemactivestyles)) {
			if ($css->level1itemactivestyles['padding'] || $css->level1itemactivestyles['margin'] || $css->level1itemactivestyles['background'] || $css->level1itemactivestyles['gradient'] || $css->level1itemactivestyles['borderradius'] || $css->level1itemactivestyles['shadow'] || $css->level1itemactivestyles['border'] || $css->level1itemactivestyles['text-align']
				|| $css->level1itemactivestyles['fontcolor'] || $css->level1itemactivestyles['fontsize'] || $css->level1itemactivestyles['textshadow']
					) {
				$csstoinject .= "\n#" . $menuID . " li.level1.active > span { " . $css->level1itemactivestyles['margin'] . $css->level1itemactivestyles['background'] . $css->level1itemactivestyles['gradient'] . $css->level1itemactivestyles['borderradius'] . $css->level1itemactivestyles['shadow'] . $css->level1itemactivestyles['border'] . " } ";
				$csstoinject .= "\n#" . $menuID . " li.level1.active > span a { " . $css->level1itemactivestyles['padding'] . $css->level1itemactivestyles['fontfamily'] . $css->level1itemactivestyles['fontcolor'] . $css->level1itemactivestyles['fontsize'] . $css->level1itemactivestyles['textshadow'] . $css->level1itemactivestyles['text-align'] . $css->level1itemactivestyles['text-transform'] . $css->level1itemactivestyles['fontweight'] . " } ";
			}
			if ($css->level1itemactivestyles['descfontcolor'] || $css->level1itemactivestyles['descfontsize']
			) {
				$csstoinject .= "\n#" . $menuID . " li.level1.active > span span.accordeonckdesc { " . $css->level1itemactivestyles['descfontcolor'] . $css->level1itemactivestyles['descfontsize'] . " } ";
			}
		}
		
		// level 2 styles
		if (isset($css->level2menustyles)) {
			if ($css->level2menustyles['padding'] || $css->level2menustyles['margin'] || $css->level2menustyles['background'] || $css->level2menustyles['gradient'] || $css->level2menustyles['borderradius'] || $css->level2menustyles['shadow'] || $css->level2menustyles['border']
					) {
				$csstoinject .= "\n#" . $menuID . " li.level1 > ul { " . $css->level2menustyles['padding'] . $css->level2menustyles['margin'] . $css->level2menustyles['background'] . $css->level2menustyles['gradient'] . $css->level2menustyles['borderradius'] . $css->level2menustyles['shadow'] . $css->level2menustyles['border'] . " } ";
			}
		}

		// level 2 styles
		if (isset($css->level2itemgroup)) {
			if ($css->level2itemgroup['padding'] || $css->level2itemgroup['margin'] || $css->level2itemgroup['background'] || $css->level2itemgroup['gradient'] || $css->level2itemgroup['borderradius'] || $css->level2itemgroup['shadow'] || $css->level2itemgroup['border']
					) {
				$csstoinject .= "\n#" . $menuID . " li.level2 { " . $css->level2itemgroup['padding'] . $css->level2itemgroup['margin'] . $css->level2itemgroup['background'] . $css->level2itemgroup['gradient'] . $css->level2itemgroup['borderradius'] . $css->level2itemgroup['shadow'] . $css->level2itemgroup['border'] . " } ";
			}
		}

		// level 2 styles
		if (isset($css->level2itemnormalstyles)) {
			if ($css->level2itemnormalstyles['padding'] || $css->level2itemnormalstyles['margin'] || $css->level2itemnormalstyles['background'] || $css->level2itemnormalstyles['gradient'] || $css->level2itemnormalstyles['borderradius'] || $css->level2itemnormalstyles['shadow'] || $css->level2itemnormalstyles['border'] || $css->level2itemnormalstyles['text-align']
				|| $css->level2itemnormalstyles['fontcolor'] || $css->level2itemnormalstyles['fontweight'] || $css->level2itemnormalstyles['fontsize'] || $css->level2itemnormalstyles['textshadow'] || $css->level2itemnormalstyles['text-transform']
					) {
				$csstoinject .= "\n#" . $menuID . " li.level2 > span { " . $css->level2itemnormalstyles['margin'] . $css->level2itemnormalstyles['background'] . $css->level2itemnormalstyles['gradient'] . $css->level2itemnormalstyles['borderradius'] . $css->level2itemnormalstyles['shadow'] . $css->level2itemnormalstyles['border'] . " } ";
				$csstoinject .= "\n#" . $menuID . " li.level2 > span a { " . $css->level2itemnormalstyles['padding'] . $css->level2itemnormalstyles['text-align'] . $css->level2itemnormalstyles['fontfamily'] . $css->level2itemnormalstyles['fontcolor'] . $css->level2itemnormalstyles['fontsize'] . $css->level2itemnormalstyles['textshadow'] . $css->level2itemnormalstyles['text-align'] . $css->level2itemnormalstyles['text-transform'] . $css->level2itemnormalstyles['fontweight'] . " } ";
			}
			if ($css->level2itemnormalstyles['descfontcolor'] || $css->level2itemnormalstyles['descfontsize']
			) {
				$csstoinject .= "\n#" . $menuID . " li.level2 > span span.accordeonckdesc { " . $css->level2itemnormalstyles['descfontcolor'] . $css->level2itemnormalstyles['descfontsize'] . " } ";
			}
		}
		
		// level 2 styles
		if (isset($css->level2itemhoverstyles)) {
			if ($css->level2itemhoverstyles['padding'] || $css->level2itemhoverstyles['margin'] || $css->level2itemhoverstyles['background'] || $css->level2itemhoverstyles['gradient'] || $css->level2itemhoverstyles['borderradius'] || $css->level2itemhoverstyles['shadow'] || $css->level2itemhoverstyles['border'] || $css->level2itemhoverstyles['text-align']
				|| $css->level2itemhoverstyles['fontcolor'] || $css->level2itemhoverstyles['fontsize'] || $css->level2itemhoverstyles['textshadow']
					) {
				$csstoinject .= "\n#" . $menuID . " li.level2:hover > span { " . $css->level2itemhoverstyles['margin'] . $css->level2itemhoverstyles['background'] . $css->level2itemhoverstyles['gradient'] . $css->level2itemhoverstyles['borderradius'] . $css->level2itemhoverstyles['shadow'] . $css->level2itemhoverstyles['border'] . " } ";
				$csstoinject .= "\n#" . $menuID . " li.level2:hover > span a { " . $css->level2itemhoverstyles['padding'] . $css->level2itemhoverstyles['text-align'] . $css->level2itemhoverstyles['fontfamily'] . $css->level2itemhoverstyles['fontcolor'] . $css->level2itemhoverstyles['fontsize'] . $css->level2itemhoverstyles['textshadow'] . $css->level2itemhoverstyles['text-align'] . $css->level2itemhoverstyles['text-transform'] . $css->level2itemhoverstyles['fontweight'] . " } ";
				$csstoinject .= "\n#" . $menuID . " li.level2.active > span { " . $css->level2itemhoverstyles['margin'] . $css->level2itemhoverstyles['background'] . $css->level2itemhoverstyles['gradient'] . $css->level2itemhoverstyles['borderradius'] . $css->level2itemhoverstyles['shadow'] . $css->level2itemhoverstyles['border'] . " } ";
				$csstoinject .= "\n#" . $menuID . " li.level2.active > span a { " . $css->level2itemhoverstyles['padding'] . $css->level2itemhoverstyles['text-align'] . $css->level2itemhoverstyles['fontfamily'] . $css->level2itemhoverstyles['fontcolor'] . $css->level2itemhoverstyles['fontsize'] . $css->level2itemhoverstyles['textshadow'] . $css->level2itemhoverstyles['text-align'] . $css->level2itemhoverstyles['text-transform'] . $css->level2itemhoverstyles['fontweight'] . " } ";
			}
			if ($css->level2itemhoverstyles['descfontcolor'] || $css->level2itemhoverstyles['descfontsize']
			) {
				$csstoinject .= "\n#" . $menuID . " li.level2:hover > span span.accordeonckdesc { " . $css->level2itemhoverstyles['descfontcolor'] . $css->level2itemhoverstyles['descfontsize'] . " } ";
				$csstoinject .= "\n#" . $menuID . " li.level2.active > span span.accordeonckdesc { " . $css->level2itemhoverstyles['descfontcolor'] . $css->level2itemhoverstyles['descfontsize'] . " } ";
			}
		}

		// level 2 styles
		if (isset($css->level2itemactivestyles)) {
			if ($css->level2itemactivestyles['padding'] || $css->level2itemactivestyles['margin'] || $css->level2itemactivestyles['background'] || $css->level2itemactivestyles['gradient'] || $css->level2itemactivestyles['borderradius'] || $css->level2itemactivestyles['shadow'] || $css->level2itemactivestyles['border'] || $css->level2itemactivestyles['text-align']
				|| $css->level2itemactivestyles['fontcolor'] || $css->level2itemactivestyles['fontsize'] || $css->level2itemactivestyles['textshadow']
					) {
				$csstoinject .= "\n#" . $menuID . " li.level2.active > span { " . $css->level2itemactivestyles['margin'] . $css->level2itemactivestyles['background'] . $css->level2itemactivestyles['gradient'] . $css->level2itemactivestyles['borderradius'] . $css->level2itemactivestyles['shadow'] . $css->level2itemactivestyles['border'] . " } ";
				$csstoinject .= "\n#" . $menuID . " li.level2.active > span a { " . $css->level2itemactivestyles['padding'] . $css->level2itemactivestyles['text-align'] . $css->level2itemactivestyles['fontfamily'] . $css->level2itemactivestyles['fontcolor'] . $css->level2itemactivestyles['fontsize'] . $css->level2itemactivestyles['textshadow'] . $css->level2itemactivestyles['text-align'] . $css->level2itemactivestyles['text-transform'] . $css->level2itemactivestyles['fontweight'] . " } ";
			}
			if ($css->level2itemactivestyles['descfontcolor'] || $css->level2itemactivestyles['descfontsize']
			) {
				$csstoinject .= "\n#" . $menuID . " li.level2.active > span span.accordeonckdesc { " . $css->level2itemactivestyles['descfontcolor'] . $css->level2itemactivestyles['descfontsize'] . " } ";
			}
		}
		
		// level 3 styles
		if (isset($css->level3menustyles)) {
			if ($css->level3menustyles['padding'] || $css->level3menustyles['margin'] || $css->level3menustyles['background'] || $css->level3menustyles['gradient'] || $css->level3menustyles['borderradius'] || $css->level3menustyles['shadow'] || $css->level3menustyles['border']
					) {
				$csstoinject .= "\n#" . $menuID . " li.level2 ul[class^=\"content\"] { " . $css->level3menustyles['padding'] . $css->level3menustyles['margin'] . $css->level3menustyles['background'] . $css->level3menustyles['gradient'] . $css->level3menustyles['borderradius'] . $css->level3menustyles['shadow'] . $css->level3menustyles['border'] . " } ";
			}
		}

		// level 3 styles
		if (isset($css->level3itemgroup)) {
			if ($css->level3itemgroup['padding'] || $css->level3itemgroup['margin'] || $css->level3itemgroup['background'] || $css->level3itemgroup['gradient'] || $css->level3itemgroup['borderradius'] || $css->level3itemgroup['shadow'] || $css->level3itemgroup['border']
					) {
				$csstoinject .= "\n#" . $menuID . " li.level2 li.accordeonck { " . $css->level3itemgroup['padding'] . $css->level3itemgroup['margin'] . $css->level3itemgroup['background'] . $css->level3itemgroup['gradient'] . $css->level3itemgroup['borderradius'] . $css->level3itemgroup['shadow'] . $css->level3itemgroup['border'] . " } ";
			}
		}

		// level 3 styles
		if (isset($css->level3itemnormalstyles)) {
			if ($css->level3itemnormalstyles['padding'] || $css->level3itemnormalstyles['margin'] || $css->level3itemnormalstyles['background'] || $css->level3itemnormalstyles['gradient'] || $css->level3itemnormalstyles['borderradius'] || $css->level3itemnormalstyles['shadow'] || $css->level3itemnormalstyles['border'] || $css->level3itemnormalstyles['text-align']
				|| $css->level3itemnormalstyles['fontcolor'] || $css->level3itemnormalstyles['fontweight'] || $css->level3itemnormalstyles['fontsize'] || $css->level3itemnormalstyles['textshadow'] || $css->level3itemnormalstyles['text-transform']
					) {
				$csstoinject .= "\n#" . $menuID . " li.level2 li.accordeonck > span { " . $css->level3itemnormalstyles['margin'] . $css->level3itemnormalstyles['background'] . $css->level3itemnormalstyles['gradient'] . $css->level3itemnormalstyles['borderradius'] . $css->level3itemnormalstyles['shadow'] . $css->level3itemnormalstyles['border'] . " } ";
				$csstoinject .= "\n#" . $menuID . " li.level2 li.accordeonck > span a { " . $css->level3itemnormalstyles['padding'] . $css->level3itemnormalstyles['text-align'] . $css->level3itemnormalstyles['fontfamily'] . $css->level3itemnormalstyles['fontcolor'] . $css->level3itemnormalstyles['fontsize'] . $css->level3itemnormalstyles['textshadow'] . $css->level3itemnormalstyles['text-align'] . $css->level3itemnormalstyles['text-transform'] . $css->level3itemnormalstyles['fontweight'] . " } ";
			}
			if ($css->level3itemnormalstyles['descfontcolor'] || $css->level3itemnormalstyles['descfontsize']
			) {
				$csstoinject .= "\n#" . $menuID . " li.level2 li.accordeonck > span span.accordeonckdesc { " . $css->level3itemnormalstyles['descfontcolor'] . $css->level3itemnormalstyles['descfontsize'] . " } ";
			}
		}
		
		// level 3 styles
		if (isset($css->level3itemhoverstyles)) {
			if ($css->level3itemhoverstyles['padding'] || $css->level3itemhoverstyles['margin'] || $css->level3itemhoverstyles['background'] || $css->level3itemhoverstyles['gradient'] || $css->level3itemhoverstyles['borderradius'] || $css->level3itemhoverstyles['shadow'] || $css->level3itemhoverstyles['border'] || $css->level3itemhoverstyles['text-align']
				|| $css->level3itemhoverstyles['fontcolor'] || $css->level3itemhoverstyles['fontsize'] || $css->level3itemhoverstyles['textshadow']
					) {
				$csstoinject .= "\n#" . $menuID . " li.level2 li.accordeonck:hover > span { " . $css->level3itemhoverstyles['margin'] . $css->level3itemhoverstyles['background'] . $css->level3itemhoverstyles['gradient'] . $css->level3itemhoverstyles['borderradius'] . $css->level3itemhoverstyles['shadow'] . $css->level3itemhoverstyles['border'] . " } ";
				$csstoinject .= "\n#" . $menuID . " li.level2 li.accordeonck:hover > span a { " . $css->level3itemhoverstyles['padding'] . $css->level3itemhoverstyles['text-align'] . $css->level3itemhoverstyles['fontfamily'] . $css->level3itemhoverstyles['fontcolor'] . $css->level3itemhoverstyles['fontsize'] . $css->level3itemhoverstyles['textshadow'] . $css->level3itemhoverstyles['text-align'] . $css->level3itemhoverstyles['text-transform'] . $css->level3itemhoverstyles['fontweight'] . " } ";
				$csstoinject .= "\n#" . $menuID . " li.level2 li.accordeonck.active > span { " . $css->level3itemhoverstyles['margin'] . $css->level3itemhoverstyles['background'] . $css->level3itemhoverstyles['gradient'] . $css->level3itemhoverstyles['borderradius'] . $css->level3itemhoverstyles['shadow'] . $css->level3itemhoverstyles['border'] . " } ";
				$csstoinject .= "\n#" . $menuID . " li.level2 li.accordeonck.active > span a { " . $css->level3itemhoverstyles['padding'] . $css->level3itemhoverstyles['text-align'] . $css->level3itemhoverstyles['fontfamily'] . $css->level3itemhoverstyles['fontcolor'] . $css->level3itemhoverstyles['fontsize'] . $css->level3itemhoverstyles['textshadow'] . $css->level3itemhoverstyles['text-align'] . $css->level3itemhoverstyles['text-transform'] . $css->level3itemhoverstyles['fontweight'] . " } ";
			}
			if ($css->level3itemhoverstyles['descfontcolor'] || $css->level3itemhoverstyles['descfontsize']
			) {
				$csstoinject .= "\n#" . $menuID . " li.level2 li.accordeonck:hover > span span.accordeonckdesc { " . $css->level3itemhoverstyles['descfontcolor'] . $css->level3itemhoverstyles['descfontsize'] . " } ";
				$csstoinject .= "\n#" . $menuID . " li.level2 li.accordeonck.active > span span.accordeonckdesc { " . $css->level3itemhoverstyles['descfontcolor'] . $css->level3itemhoverstyles['descfontsize'] . " } ";
			}
		}

		// level 3 styles
		if (isset($css->level3itemactivestyles)) {
			if ($css->level3itemactivestyles['padding'] || $css->level3itemactivestyles['margin'] || $css->level3itemactivestyles['background'] || $css->level3itemactivestyles['gradient'] || $css->level3itemactivestyles['borderradius'] || $css->level3itemactivestyles['shadow'] || $css->level3itemactivestyles['border'] || $css->level3itemactivestyles['text-align']
				|| $css->level3itemactivestyles['fontcolor'] || $css->level3itemactivestyles['fontsize'] || $css->level3itemactivestyles['textshadow']
					) {
				$csstoinject .= "\n#" . $menuID . " li.level2 li.accordeonck.active > span { " . $css->level3itemactivestyles['margin'] . $css->level3itemactivestyles['background'] . $css->level3itemactivestyles['gradient'] . $css->level3itemactivestyles['borderradius'] . $css->level3itemactivestyles['shadow'] . $css->level3itemactivestyles['border'] . " } ";
				$csstoinject .= "\n#" . $menuID . " li.level2 li.accordeonck.active > span a { " . $css->level3itemactivestyles['padding'] . $css->level3itemactivestyles['text-align'] . $css->level3itemactivestyles['fontfamily'] . $css->level3itemactivestyles['fontcolor'] . $css->level3itemactivestyles['fontsize'] . $css->level3itemactivestyles['textshadow'] . $css->level3itemactivestyles['text-align'] . $css->level3itemactivestyles['text-transform'] . $css->level3itemactivestyles['fontweight'] . " } ";
			}
			if ($css->level3itemactivestyles['descfontcolor'] || $css->level3itemactivestyles['descfontsize']
			) {
				$csstoinject .= "\n#" . $menuID . " li.level2 li.accordeonck.active > span span.accordeonckdesc { " . $css->level3itemactivestyles['descfontcolor'] . $css->level3itemactivestyles['descfontsize'] . " } ";
			}
		}

		if ($params->get('customcss', '') != '[]')
			$csstoinject .= str_replace('|ID|', 'ul#' . $menuCSSID, $params->get('customcss', ''));

		return $csstoinject;
	}

	/**
	 * Create the css properties
	 * @param JRegistry $params
	 * @param string $prefix the xml field prefix
	 *
	 * @return Array
	 */
	static function createCss($menuID, $params, $prefix = 'menu', $important = false, $itemid = '', $use_svggradient = true) {
		$css = Array();
		$important = ($important == true ) ? ' !important' : '';
		$csspaddingtop = ($params->get($prefix . 'paddingtop') != '') ? 'padding-top: ' . Helper::testUnit($params->get($prefix . 'paddingtop', '0')) . $important . ';' : '';
		$csspaddingright = ($params->get($prefix . 'paddingright') != '') ? 'padding-right: ' . Helper::testUnit($params->get($prefix . 'paddingright', '0')) . $important . ';' : '';
		$csspaddingbottom = ($params->get($prefix . 'paddingbottom') != '') ? 'padding-bottom: ' . Helper::testUnit($params->get($prefix . 'paddingbottom', '0')) . $important . ';' : '';
		$csspaddingleft = ($params->get($prefix . 'paddingleft') != '') ? 'padding-left: ' . Helper::testUnit($params->get($prefix . 'paddingleft', '0')) . $important . ';' : '';
		$css['padding'] = $csspaddingtop . $csspaddingright . $csspaddingbottom . $csspaddingleft;
		$cssmargintop = ($params->get($prefix . 'margintop') != '') ? 'margin-top: ' . Helper::testUnit($params->get($prefix . 'margintop', '0')) . $important . ';' : '';
		$cssmarginright = ($params->get($prefix . 'marginright') != '') ? 'margin-right: ' . Helper::testUnit($params->get($prefix . 'marginright', '0')) . $important . ';' : '';
		$cssmarginbottom = ($params->get($prefix . 'marginbottom') != '') ? 'margin-bottom: ' . Helper::testUnit($params->get($prefix . 'marginbottom', '0')) . $important . ';' : '';
		$cssmarginleft = ($params->get($prefix . 'marginleft') != '') ? 'margin-left: ' . Helper::testUnit($params->get($prefix . 'marginleft', '0')) . $important . ';' : '';
		$css['margin'] = $cssmargintop . $cssmarginright . $cssmarginbottom . $cssmarginleft;
		$bgcolor1 = ($params->get($prefix . 'bgcolor1') && $params->get($prefix . 'bgopacity') !== null && $params->get($prefix . 'bgopacity') !== '') ? Helper::hex2RGB($params->get($prefix . 'bgcolor1'), $params->get($prefix . 'bgopacity')) : $params->get($prefix . 'bgcolor1');
		$css['background'] = ($params->get($prefix . 'bgcolor1')) ? 'background: ' . $bgcolor1 . $important . ';' : '';
		$css['background'] .= ($params->get($prefix . 'bgcolor1')) ? 'background-color: ' . $bgcolor1 . $important . ';' : '';
		$css['background'] .= ( $params->get($prefix . 'bgimage')) ? 'background-image: url("' . \JUri::root() . $params->get($prefix . 'bgimage') . '")' . $important . ';' : '';
		$css['background'] .= ( $params->get($prefix . 'bgimage')) ? 'background-repeat: ' . $params->get($prefix . 'bgimagerepeat') . $important . ';' : '';
		$css['background'] .= ( $params->get($prefix . 'bgimage')) ? 'background-position: ' . $params->get($prefix . 'bgpositionx') . ' ' . $params->get($prefix . 'bgpositiony') . $important . ';' : '';

		$bgcolor2 = ($params->get($prefix . 'bgcolor2') && $params->get($prefix . 'bgopacity') && $params->get($prefix . 'bgopacity') !== '') ? Helper::hex2RGB($params->get($prefix . 'bgcolor2'), $params->get($prefix . 'bgopacity')) : $params->get($prefix . 'bgcolor2');
		// manage gradient svg for ie9
		$svggradient = '';
		// if ($use_svggradient) {
			// $svggradientfile = '';
			// if ($css['background'] AND $params->get($prefix . 'bgcolor2')) {
				// $svggradientfile = self::createSvgGradient($menuID, $prefix . $itemid, $params->get($prefix . 'bgcolor1', ''), $params->get($prefix . 'bgcolor2', ''));
			// }
			// $svggradient = $svggradientfile ? "background-image: url(\"" . $svggradientfile . "\")" . $important . ";" : "";
		// }
		$css['gradient'] = ($css['background'] AND $params->get($prefix . 'bgcolor2')) ?
				$svggradient
				. "background: -moz-linear-gradient(top,  " . $bgcolor1 . " 0%, " . $bgcolor2 . " 100%)" . $important . ";"
				. "background: -webkit-gradient(linear, left top, left bottom, color-stop(0%," . $bgcolor1 . "), color-stop(100%," . $bgcolor2 . "))" . $important . "; "
				. "background: -webkit-linear-gradient(top,  " . $bgcolor1 . " 0%," . $bgcolor2 . " 100%)" . $important . ";"
				. "background: -o-linear-gradient(top,  " . $bgcolor1 . " 0%," . $bgcolor2 . " 100%)" . $important . ";"
				. "background: -ms-linear-gradient(top,  " . $bgcolor1 . " 0%," . $bgcolor2 . " 100%)" . $important . ";"
				. "background: linear-gradient(top,  " . $bgcolor1 . " 0%," . $bgcolor2 . " 100%)" . $important . "; " : '';
//                . "filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='" . $params->get($prefix . 'bgcolor1', '#f0f0f0') . "', endColorstr='" . $params->get($prefix . 'bgcolor2', '#e3e3e3') . "',GradientType=0 );" : '';
		$css['borderradius'] = ($params->get($prefix . 'roundedcornerstl', '') != '' || $params->get($prefix . 'roundedcornerstr', '') != '' || $params->get($prefix . 'roundedcornersbr', '') != '' || $params->get($prefix . 'roundedcornersbl', '') != '') ?
				'-moz-border-radius: ' . Helper::testUnit($params->get($prefix . 'roundedcornerstl', '0')) . ' ' . Helper::testUnit($params->get($prefix . 'roundedcornerstr', '0')) . ' ' . Helper::testUnit($params->get($prefix . 'roundedcornersbr', '0')) . ' ' . Helper::testUnit($params->get($prefix . 'roundedcornersbl', '0')) . $important . ';'
				. '-webkit-border-radius: ' . Helper::testUnit($params->get($prefix . 'roundedcornerstl', '0')) . ' ' . Helper::testUnit($params->get($prefix . 'roundedcornerstr', '0')) . ' ' . Helper::testUnit($params->get($prefix . 'roundedcornersbr', '0')) . ' ' . Helper::testUnit($params->get($prefix . 'roundedcornersbl', '0')) . $important . ';'
				. 'border-radius: ' . Helper::testUnit($params->get($prefix . 'roundedcornerstl', '0')) . ' ' . Helper::testUnit($params->get($prefix . 'roundedcornerstr', '0')) . ' ' . Helper::testUnit($params->get($prefix . 'roundedcornersbr', '0')) . ' ' . Helper::testUnit($params->get($prefix . 'roundedcornersbl', '0')) . $important . ';' : '';
		$shadowinset = $params->get($prefix . 'shadowinset', 0) ? 'inset ' : '';
		$css['shadow'] = ($params->get($prefix . 'shadowcolor') AND $params->get($prefix . 'shadowblur') != '') ?
				'-moz-box-shadow: ' . $shadowinset . Helper::testUnit($params->get($prefix . 'shadowoffsetx', '0')) . ' ' . Helper::testUnit($params->get($prefix . 'shadowoffsety', '0')) . ' ' . Helper::testUnit($params->get($prefix . 'shadowblur', '')) . ' ' . Helper::testUnit($params->get($prefix . 'shadowspread', '0')) . ' ' . $params->get($prefix . 'shadowcolor', '') . $important . ';'
				. '-webkit-box-shadow: ' . $shadowinset . Helper::testUnit($params->get($prefix . 'shadowoffsetx', '0')) . ' ' . Helper::testUnit($params->get($prefix . 'shadowoffsety', '0')) . ' ' . Helper::testUnit($params->get($prefix . 'shadowblur', '')) . ' ' . Helper::testUnit($params->get($prefix . 'shadowspread', '0')) . ' ' . $params->get($prefix . 'shadowcolor', '') . $important . ';'
				. 'box-shadow: ' . $shadowinset . Helper::testUnit($params->get($prefix . 'shadowoffsetx', '0')) . ' ' . Helper::testUnit($params->get($prefix . 'shadowoffsety', '0')) . ' ' . Helper::testUnit($params->get($prefix . 'shadowblur', '')) . ' ' . Helper::testUnit($params->get($prefix . 'shadowspread', '0')) . ' ' . $params->get($prefix . 'shadowcolor', '') . $important . ';' :
				(($params->get($prefix . 'useshadow') && $params->get($prefix . 'shadowblur') == '0') ? '-moz-box-shadow: none' . $important . ';'
						. '-webkit-box-shadow: none' . $important . ';'
						. 'box-shadow: none' . $important . ';' : '');
		$borderstyle = $params->get($prefix . 'borderstyle', 'solid') ? $params->get($prefix . 'borderstyle', 'solid') : 'solid';
		$bordertopstyle = $params->get($prefix . 'bordertopstyle', 'solid') ? $params->get($prefix . 'bordertopstyle', 'solid') : $borderstyle;
		$borderrightstyle = $params->get($prefix . 'borderrightstyle', 'solid') ? $params->get($prefix . 'borderrightstyle', 'solid') : $borderstyle;
		$borderbottomstyle = $params->get($prefix . 'borderbottomstyle', 'solid') ? $params->get($prefix . 'borderbottomstyle', 'solid') : $borderstyle;
		$borderleftstyle = $params->get($prefix . 'borderleftstyle', 'solid') ? $params->get($prefix . 'borderleftstyle', 'solid') : $borderstyle;
		$bordercolor = $params->get($prefix . 'bordercolor', '') ? $params->get($prefix . 'bordercolor', '') : '';
		$bordertopcolor = $params->get($prefix . 'bordertopcolor', '') ? $params->get($prefix . 'bordertopcolor', '') : $bordercolor;
		$borderrightcolor = $params->get($prefix . 'borderrightcolor', '') ? $params->get($prefix . 'borderrightcolor', '') : $bordercolor;
		$borderbottomcolor = $params->get($prefix . 'borderbottomcolor', '') ? $params->get($prefix . 'borderbottomcolor', '') : $bordercolor;
		$borderleftcolor = $params->get($prefix . 'borderleftcolor', '') ? $params->get($prefix . 'borderleftcolor', '') : $bordercolor;

		$css['border'] = (($params->get($prefix . 'bordertopwidth') == '0') ? 'border-top: none' . $important . ';' : (($params->get($prefix . 'bordertopwidth') != '' AND $bordertopcolor) ? 'border-top: ' . $bordertopcolor . ' ' . Helper::testUnit($params->get($prefix . 'bordertopwidth', '')) . ' ' . $bordertopstyle . ' ' . $important . ';' : '') )
				. (($params->get($prefix . 'borderrightwidth') == '0') ? 'border-right: none' . $important . ';' : (($params->get($prefix . 'borderrightwidth') != '' AND $borderrightcolor) ? 'border-right: ' . $borderrightcolor . ' ' . Helper::testUnit($params->get($prefix . 'borderrightwidth', '')) . ' ' . $borderrightstyle . ' ' . $important . ';' : '') )
				. (($params->get($prefix . 'borderbottomwidth') == '0') ? 'border-bottom: none' . $important . ';' : (($params->get($prefix . 'borderbottomwidth') != '' AND $borderbottomcolor) ? 'border-bottom: ' . $borderbottomcolor . ' ' . Helper::testUnit($params->get($prefix . 'borderbottomwidth', '')) . ' ' . $borderbottomstyle . ' ' . $important . ';' : '') )
				. (($params->get($prefix . 'borderleftwidth') == '0') ? 'border-left: none' . $important . ';' : (($params->get($prefix . 'borderleftwidth') != '' AND $borderleftcolor) ? 'border-left: ' . $borderleftcolor . ' ' . Helper::testUnit($params->get($prefix . 'borderleftwidth', '')) . ' ' . $borderleftstyle . ' ' . $important . ';' : '') );
		$css['fontfamily'] = ($params->get($prefix . 'fontfamily') != '') ?
				'font-family: ' . $params->get($prefix . 'fontfamily') . $important . ';' : '';
		$css['fontsize'] = ($params->get($prefix . 'fontsize') != '') ?
				'font-size: ' . Helper::testUnit($params->get($prefix . 'fontsize')) . $important . ';' : '';
		$css['fontcolor'] = ($params->get($prefix . 'fontcolor') != '') ?
				'color: ' . $params->get($prefix . 'fontcolor') . $important . ';' : '';
		$css['fontweight'] = ($params->get($prefix . 'fontweight')  == 'bold') ?
				'font-weight: ' . $params->get($prefix . 'fontweight') . $important . ';' : '';
		$css['fontunderline'] = ($params->get($prefix . 'fontunderline')  == 'underline') ?
				'text-decoration: ' . $params->get($prefix . 'fontunderline') . $important . ';' : '';
		/* $css['fontcolorhover'] = ($params->get($prefix . 'usefont') AND $params->get($prefix . 'fontcolorhover')) ?
		  'color: ' . $params->get($prefix . 'fontcolorhover') . ';' : ''; */
		$css['descfontsize'] = ($params->get($prefix . 'descfontsize') != '') ?
				'font-size: ' . Helper::testUnit($params->get($prefix . 'descfontsize')) . $important . ';' : '';
		$css['descfontcolor'] = ($params->get($prefix . 'descfontcolor') != '') ?
				'color: ' . $params->get($prefix . 'descfontcolor') . $important . ';' : '';
		$textshadowoffsetx = ($params->get($prefix . 'textshadowoffsetx', '0') == '') ? '0px' : Helper::testUnit($params->get($prefix . 'textshadowoffsetx', '0'));
		$textshadowoffsety = ($params->get($prefix . 'textshadowoffsety', '0') == '') ? '0px' : Helper::testUnit($params->get($prefix . 'textshadowoffsety', '0'));
		$css['textshadow'] = ($params->get($prefix . 'textshadowcolor') AND $params->get($prefix . 'textshadowblur')) ?
				'text-shadow: ' . $textshadowoffsetx . ' ' . $textshadowoffsety . ' ' . Helper::testUnit($params->get($prefix . 'textshadowblur', '')) . ' ' . $params->get($prefix . 'textshadowcolor', '') . $important . ';' :
				(($params->get($prefix . 'textshadowblur') == '0') ? 'text-shadow: none' . $important . ';' : '');
		$css['text-align'] = $params->get($prefix . 'textalign') ? 'text-align: ' . $params->get($prefix . 'textalign') . $important . ';' : ''; '';
		$css['text-transform'] = ($params->get($prefix . 'texttransform') && $params->get($prefix . 'texttransform') != 'default') ? 'text-transform: ' . $params->get($prefix . 'texttransform') . $important . ';' : ''; '';
		$css['text-indent'] = ($params->get($prefix . 'textindent') && $params->get($prefix . 'textindent') != 'default') ? 'text-indent: ' . Helper::testUnit($params->get($prefix . 'textindent')) . $important . ';' : ''; '';
		$css['line-height'] = ($params->get($prefix . 'lineheight') && $params->get($prefix . 'lineheight') != 'default') ? 'line-height: ' . Helper::testUnit($params->get($prefix . 'lineheight')) . $important . ';' : ''; '';
		$css['height'] = ($params->get($prefix . 'height') && $params->get($prefix . 'height') != '') ? 'height: ' . Helper::testUnit($params->get($prefix . 'height')) . $important . ';' : ''; '';
		$css['width'] = ($params->get($prefix . 'width') && $params->get($prefix . 'width') != '') ? 'width: ' . Helper::testUnit($params->get($prefix . 'width')) . $important . ';' : ''; '';

		self::retrocompatibility_css($css, $params, $prefix);
		return $css;
	}

	static function retrocompatibility_css(& $css, $params, $prefix) {
		if ( $params->exists($prefix . 'usemargin') && $params->get($prefix . 'usemargin') != '1' ) {
			$css['margin'] = '';
			$css['padding'] = '';
		}
		if ( $params->exists($prefix . 'usebackground') && $params->get($prefix . 'usebackground') != '1' ) {
			$css['background'] = '';
			$css['gradient'] = '';
		}
		if ( $params->exists($prefix . 'usegradient') && $params->get($prefix . 'usegradient') != '1' ) {
			$css['gradient'] = '';
		}
		if ( $params->exists($prefix . 'useroundedcorners') && $params->get($prefix . 'useroundedcorners') != '1' ) {
			$css['borderradius'] = '';
		}
		if ( $params->exists($prefix . 'useshadow') && $params->get($prefix . 'useshadow') != '1' ) {
			$css['shadow'] = '';
		}
		if ( $params->exists($prefix . 'useborders') && $params->get($prefix . 'useborders') != '1' ) {
			$css['border'] = '';
		}
		if ( $params->exists($prefix . 'usefont') && $params->get($prefix . 'usefont') != '1' ) {
			$css['fontsize'] = '';
			$css['fontcolor'] = '';
			$css['fontweight'] = '';
			$css['descfontsize'] = '';
			$css['descfontcolor'] = '';
		}
		if ( $params->exists($prefix . 'usetextshadow') && $params->get($prefix . 'usetextshadow') == '1' ) {
			$css['textshadow'] = '';
		}

		$css['fontcolorhover'] = ($params->get($prefix . 'usefont') AND $params->get($prefix . 'fontcolorhover')) ?
				'color: ' . $params->get($prefix . 'fontcolorhover') . ';' : '';

	}

	/**
	 * Extract the css family name of the google font from the url
	 * @param string $gfont the font url
	 *
	 * @return string the font family
	 */
	static function get_gfontfamily($gfont) {
		// Open+Sans+Condensed:300
		if ( preg_match( '/(.*?):/', $gfont, $matches) ) {
			if ( isset($matches[1]) ) {
				$gfont = $matches[1];
			}
		}

		return ucwords(str_replace("+", " ", $gfont));
	}

	/**
	 * Get the CSS of the style
	 * @id - the style ID
	 */
	public static function getCss($id) {
		if (! $id) return '';

		$query = 'SELECT a.layoutcss, a.customcss FROM #__accordeonmenuck_styles as a WHERE (a.state IN (0, 1)) AND a.id = ' . (int)$id;
		$result = CKFof::dbLoadObject($query);

		$css = $result->layoutcss . $result->customcss;

		self::makeCssReplacement($css);

		return $css;
	}

	public static function makeCssReplacement(&$css) {
		$cssreplacements = self::getCssReplacement();
		foreach ($cssreplacements as $tag => $rep) {
			$css = str_replace($tag, $rep, $css);
		}
//		return $css;
	}

	/**
	 * List the replacement between the tags and the real final CSS rules
	 */
	public static function getCssReplacement() {
		if (! empty(self::$cssreplacements)) return self::$cssreplacements;

		// self::$cssreplacements = Array(
			// '[menustyles]' => ''
			// ,'[level1itemnormalstyles]' => '.cameraSlide img'
			// ,'[level1itemhoverstyles]' => '.camera_caption > div'
			// ,'[level1itemactivestyles]' => '.camera_caption_title'
			// ,'[level1itemparentstyles]' => '.camera_caption_desc'
			// ,'[level2menustyles]' => 'a.camera-button'
			// ,'[level2itemnormalstyles]' => 'a.camera-button:hover'
			// ,'[level2itemhoverstyles]' => '.camera_pag_ul li img'
			// ,'[level2itemactivestyles]' => '.camera_pag_ul li img'
			// ,'[level1itemnormalstylesicon]' => 'li.level1 > *:not(div) .maximenuiconck'
			// ,'[level1itemhoverstylesicon]' => 'li.level1:hover > *:not(div) .maximenuiconck'
			// ,'[level2itemnormalstylesicon]' => 'li.level1 li > *:not(div) .maximenuiconck'
			// ,'[level2itemhoverstylesicon]' => 'li.level1 li:hover > *:not(div) .maximenuiconck'
			// ,'[level3menustyles]' => '.camera_pag_ul li img'
			// ,'[level3itemnormalstyles]' => '.camera_pag_ul li img'
			// ,'[level3itemhoverstyles]' => '.camera_pag_ul li img'
			// ,'[headingstyles]' => '.camera_pag_ul li img'
			// ,'[fancystyles]' => '.camera_pag_ul li img'
		// );

		self::$cssreplacements = Array(
			'|qq|' => '"'
		);

		return self::$cssreplacements;
	}

	/*
	 * Convert fields between the old and new interface
	 */
	public static function updateInterface($fields, $order = 1) {
		$new = array(
			  'backgroundcolorstart'
			, 'backgroundcolorend'
			, 'backgroundopacity'
			, 'backgroundimageurl'
			, 'backgroundimagerepeat'
			, 'backgroundimageleft'
			, 'backgroundimagetop'
			, 'bordertopsize'
			, 'borderrightsize'
			, 'borderbottomsize'
			, 'borderleftsize'
			, 'borderradiustopleft'
			, 'borderradiustopright'
			, 'borderradiusbottomleft'
			, 'borderradiusbottomright'
			, 'stylescolor'
			, 'stylesdesccolor'
			, 'textgfont'
		);

		$old = array(
			  'bgcolor1'
			, 'bgcolor2'
			, 'bgopacity'
			, 'bgimage'
			, 'bgimagerepeat'
			, 'bgpositionx'
			, 'bgpositiony'
			, 'bordertopwidth'
			, 'borderrightwidth'
			, 'borderbottomwidth'
			, 'borderleftwidth'
			, 'roundedcornerstl'
			, 'roundedcornerstr'
			, 'roundedcornersbl'
			, 'roundedcornersbr'
			, 'stylesfontcolor'
			, 'stylesdescfontcolor'
			, 'fontfamily'
		);

		// update from old to new interface
		if ($order === 1) {
			return str_replace($old, $new, $fields);
		}
		// update from new to old interface
		return str_replace($new, $old, $fields);
	}
}

// create a new class to manage objects
if (!class_exists('CkCssParams')) {

	class CkCssParams extends \stdClass {

		function get($key) {
			return isset($this->$key) ? $this->$key : null;
		}
		
		function exists($key) {
			return isset($this->$key) ? true : false;
		}

	}

}