<?php
Namespace Accordeonmenuck;

// No direct access
defined('_JEXEC') or die;

require_once JPATH_ADMINISTRATOR . '/components/com_accordeonmenuck/helpers/defines.php';
require_once JPATH_ADMINISTRATOR . '/components/com_accordeonmenuck/helpers/style.php';

use Accordeonmenuck\CKInput;
use Accordeonmenuck\CKFof;
use Accordeonmenuck\CKText;
use Accordeonmenuck\Style;

/**
 * Accordeon Menu CK helper.
 */
class Helper {

	public static function addSidebar($vName = '') {
		$input = CKFof::getInput();
		if (!$vName) $vName = $input->get('view', 'modules', 'cmd');

		\JHtmlSidebar::addEntry(
				CKText::_('CK_MODULES'), ACCORDEONMENUCK_ADMIN_URL . '&view=modules', $vName == 'modules'
		);
		\JHtmlSidebar::addEntry(
				CKText::_('CK_JOOMLA_MENUS'), ACCORDEONMENUCK_ADMIN_URL . '&view=joomlamenus', $vName == 'joomlamenus'
		);
		// \JHtmlSidebar::addEntry(
				// CKText::_('CK_MAXI_MENUS'), ACCORDEONMENUCK_ADMIN_URL . '&view=maximenus', $vName == 'maximenus'
		// );
		\JHtmlSidebar::addEntry(
				CKText::_('CK_STYLES'), ACCORDEONMENUCK_ADMIN_URL . '&view=styles', $vName == 'styles'
		);
		\JHtmlSidebar::addEntry(
				CKText::_('CK_ABOUT'), ACCORDEONMENUCK_ADMIN_URL . '&view=about', $vName == 'about'
		);
		echo '<style>.ckadminarea {
	float: left;
	width: calc(100% - 230px);

}
.ckadminsidebar {
	float: left;
	width: 220px;
	margin-right: 10px;
}
@media only screen and (max-width:640px) {
	.ckadminsidebar, .ckadminarea {
		float: none; width: inherit;
	}
}
</style>
<div class="ckadminsidebar">' . \JHtmlSidebar::render() . '</div>';
	}

	/*
	 * Load the JS and CSS files needed to use CKBox
	 *
	 * Return void
	 */
	public static function loadCkbox() {
		$doc = \JFactory::getDocument();
		\JHtml::_('jquery.framework', true);
//		$doc->addScript(JUri::root(true) . '/media/jui/js/jquery.min.js');
		$doc->addStyleSheet(ACCORDEONMENUCK_MEDIA_URI . '/assets/ckbox.css');
		$doc->addScript(ACCORDEONMENUCK_MEDIA_URI . '/assets/ckbox.js');
	}

	public static function loadCkboxInline() {
		CKFof::addStyleSheetInline(ACCORDEONMENUCK_MEDIA_URI . '/assets/ckbox.css');
		CKFof::addScriptInline(ACCORDEONMENUCK_MEDIA_URI . '/assets/ckbox.js');
	}

	/*
	 * Get a variable from the manifest file (actually, from the manifest cache).
	 * 
	 * @return the current version
	 */
	public static function get_current_version() {
		$db = \JFactory::getDbo();
		$db->setQuery('SELECT manifest_cache FROM #__extensions WHERE name = "com_accordeonmenuck"');
		$manifest = json_decode($db->loadResult(), true);

		return $manifest['version'];
	}

	/**
	 * Gets a list of the actions that can be performed.
	 *
	 * @return	JObject
	 * @since	1.6
	 */
	public static function getActions() {
		$user = \JFactory::getUser();
		$result = new \JObject;

		$assetName = 'com_accordeonmenuck';

		$actions = array(
			'core.admin', 'core.manage', 'core.create', 'core.edit', 'core.edit.own', 'core.edit.state', 'core.delete'
		);

		foreach ($actions as $action) {
			$result->set($action, $user->authorise($action, $assetName));
		}

		return $result;
	}

	/**
	 * Get the name of the style
	 */
	public static function getStyleNameById($id) {
		if (! $id) return '';

		$result = CKFof::dbLoadResult('SELECT name from #__accordeonmenuck_styles WHERE id = "' . $id . '" AND (state IN (0, 1))');

		return $result;
	}

	/**
	 * Get the name of the menu
	 */
	public static function getJoomlaMenuNameById($menutype) {
		if (! $menutype) return '';

		$result = CKFof::dbLoadResult('SELECT title from #__menu_types WHERE menutype = "' . $menutype . '"');

		return $result;
	}

	/**
	 * Get the list of the menus
	 */
	public static function getJoomlaMenus() {
		$result = CKFof::dbLoadObjectList('SELECT id,title,menutype from #__menu_types');

		return $result;
	}

	public static function checkDbIntegrity() {
//		self::searchTable('accordeonmenuck_menus');
		self::searchTable('accordeonmenuck_styles');
	}

	private static function searchColumn($name, $type = 'text', $table = 'accordeonmenuck_styles') {
		$db = JFactory::getDbo();
		// test if the widget columns not exists
		$query = "SHOW COLUMNS FROM #__" . $table . " LIKE '" . $name . "'";
		$db->setQuery($query);
		if ($db->execute()) {
			if ( $db->loadResult()) {
				//echo 'existe deja!';return;
			} else {
				// add the SQL field to the main table
				$db->setQuery('ALTER TABLE `#__' . $table . '` ADD `' . $name . '` ' . $type . ' NOT NULL;');
				if (!$db->execute()) {
					echo '<p class="alert alert-danger">Error during table column ' . $name . ' update process !</p>';
				} else {
					echo '<p class="alert alert-success">Table column ' . $name . ' updated !</p>';
				}
			}
		} else {
			echo 'SQL error - Check existing ' . $name . ' column';
			return false;
		}
	}

	/**
	 * Look if the table exists, if not then create it
	 * 
	 * @param type $tableName
	 */
	private static function searchTable($tableName) {
		$db = CKFof::getDbo();
		$tablesList = $db->getTableList();
		$tableExists = in_array($db->getPrefix() . $tableName, $tablesList);
		// test if the table not exists

		if (! $tableExists) {
			self::createTable($tableName);
		}
	}

	private static function createTable($tableName) {
		switch ($tableName) {
			case 'accordeonmenuck_styles' :
				$query = "CREATE TABLE IF NOT EXISTS `#__accordeonmenuck_styles` (
	  `id` int(10) NOT NULL AUTO_INCREMENT,
	  `name` text NOT NULL,
	  `state` int(10) NOT NULL DEFAULT '1',
	  `params` longtext NOT NULL,
	  `layoutcss` text NOT NULL,
	  `customcss` text NOT NULL,
	  `checked_out` varchar(10) NOT NULL,
	  PRIMARY KEY (`id`)
	) DEFAULT CHARSET=utf8;";
				break;
			case 'accordeonmenuck_menus' :
				$query = "CREATE TABLE IF NOT EXISTS `#__accordeonmenuck_menus` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `state` int(10) NOT NULL DEFAULT '1',
  `params` longtext NOT NULL,
  `layouthtml` text NOT NULL,
  `layoutcss` text NOT NULL,
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8;";
				break;
			default :
				break;
		} 

		$db = CKFof::getDbo();
		$db->setQuery($query);
		if (! $db->execute($query)) {
			echo '<p class="alert alert-danger">Error during table ' . $tableName . ' creation process !</p>';
		} else {
			echo '<p class="alert alert-success">Table ' . $tableName . ' created with success !</p>';
		}
	}

	public static function decodeChars($a) {
		$search = array('|quot|'
			, '|qq|'
			, '|ob|'
			, '|cb|'
			, '|tt|'
			, '|rr|'
			);
		$replace = array('"'
			, '"'
			, '{'
			, '}'
			, "\t"
			, "\n"
			);
		return str_replace($search, $replace, $a);
	}

	public static function encodeChars($a) {
		$search = array('"'
			, '"'
			, '{'
			, '}'
			, "\t"
			, "\n"
			);
		$replace = array('|quot|'
			, '|qq|'
			, '|ob|'
			, '|cb|'
			, '|tt|'
			, '|rr|'
			);
		return str_replace($search, $replace, $a);
	}

	/**
	 * Test if there is already a unit, else add the px
	 *
	 * @param string $value
	 * @return string
	 */
	public static function testUnit($value) {
		if ((stristr($value, 'px')) OR (stristr($value, 'em')) OR (stristr($value, '%')) OR (stristr($value, 'auto')) ) {
			return $value;
		}

		if ($value == '') {
			$value = 0;
		}

		return $value . 'px';
	}

	/**
	 * Convert a hexa decimal color code to its RGB equivalent
	 *
	 * @param string $hexStr (hexadecimal color value)
	 * @param boolean $returnAsString (if set true, returns the value separated by the separator character. Otherwise returns associative array)
	 * @param string $seperator (to separate RGB values. Applicable only if second parameter is true.)
	 * @return array or string (depending on second parameter. Returns False if invalid hex color value)
	 */
	static function hex2RGB($hexStr, $opacity) {
		if ($opacity > 1) $opacity = $opacity/100;
		$hexStr = preg_replace("/[^0-9A-Fa-f]/", '', $hexStr); // Gets a proper hex string
		$rgbArray = array();
		if (strlen($hexStr) == 6) { //If a proper hex code, convert using bitwise operation. No overhead... faster
			$colorVal = hexdec($hexStr);
			$rgbArray['red'] = 0xFF & ($colorVal >> 0x10);
			$rgbArray['green'] = 0xFF & ($colorVal >> 0x8);
			$rgbArray['blue'] = 0xFF & $colorVal;
		} elseif (strlen($hexStr) == 3) { //if shorthand notation, need some string manipulations
			$rgbArray['red'] = hexdec(str_repeat(substr($hexStr, 0, 1), 2));
			$rgbArray['green'] = hexdec(str_repeat(substr($hexStr, 1, 1), 2));
			$rgbArray['blue'] = hexdec(str_repeat(substr($hexStr, 2, 1), 2));
		} else {
			return false; //Invalid hex color code
		}
		$rgbacolor = "rgba(" . $rgbArray['red'] . "," . $rgbArray['green'] . "," . $rgbArray['blue'] . "," . $opacity . ")";

		return $rgbacolor;
	}

		public static function getProMessage() {
		$html = '<div class="ckinfo"><i class="fas fa-info"></i><a href="https://www.joomlack.fr/en/joomla-extensions/accordeonmenu-ck" target="_blank">' . CKText::_('ACCORDEONMENUCK_ONLY_PRO') . '</a></div>';
	
		return $html;
	}

	static function getArticleCategory($article_id) {
			$db = \JFactory::getDBO();
			$query = "SELECT catid"
					." FROM #__content"
					// ." WHERE published = 1"
					." WHERE id = " . (int) $article_id;
			
			$db->setQuery($query);

			if ($db->execute()) {
				$parent_category_id = (int)$db->loadResult();
			} else {
				$parent_category_id = null;
			}
		return $parent_category_id;
	}
}
