<?php

/**
 * @copyright	Copyright (C) 2011 Cedric KEIFLIN alias ced1870
 * https://www.joomlack.fr
 * Module Accordeon Menu CK
 * @license		GNU/GPL
 * */
defined('JPATH_BASE') or die;
jimport('joomla.filesystem.file');
jimport('joomla.form.formfield');
JFormHelper::loadFieldClass('cklist');

class JFormFieldCkhikashopcategory extends JFormFieldlist {

    protected $type = 'ckhikashopcategory';

    protected function getOptions() {
        // if the component is not installed
        if (!JFolder::exists(JPATH_ROOT . '/administrator/components/com_hikashop')
                OR !JFile::exists(JPATH_ROOT . '/modules/mod_accordeonmenuck/helper_hikashop.php')) {
            // add the root item
            $option = new stdClass();
            $option->text = JText::_('ACCORDEONMENUCK_HIKASHOP_NOTFOUND');
            $option->value = '0';
            $options[] = $option;
            // Merge any additional options in the XML definition.
            $options = array_merge(parent::getOptions(), $options);

            return $options;
        }

        // get the categories form the helper
        $params = new JRegistry();
        require_once JPATH_ROOT . '/modules/mod_accordeonmenuck/helper_hikashop.php';
        $cats = modAccordeonmenuckhikashopHelper::getItems($params, true);

        // add the root item
        $option = new stdClass();
        $option->text = JText::_('ACCORDEONMENUCK_HIKASHOP_ROOTNODE');
        $option->value = '2';
        $options[] = $option;
        foreach ($cats as $cat) {
            $option = new stdClass();
            $option->text = str_repeat(" - ", $cat->level - 1) . $cat->category_name;
            $option->value = $cat->id;
            $options[] = $option;
        }
        // Merge any additional options in the XML definition.
        $options = array_merge(parent::getOptions(), $options);

        return $options;
    }

}
